/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import ru.infor.beanviewer.swing.viewers.list.SortIcon;

public class MultiSortTableCellHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 186587632187568723L;
    protected SortIcon sortIcon = new SortIcon(6);
    JLabelRotate labelRotate = new JLabelRotate();

    public JLabelRotate getLabelRotate() {
        return this.labelRotate;
    }

    public void setDirection(String direction) {
        if ("VERTICAL_UP".equals(direction)) {
            this.labelRotate.setDirection(JLabelRotate.Direction.VERTICAL_UP);
        } else if ("VERTICAL_DOWN".equals(direction)) {
            this.labelRotate.setDirection(JLabelRotate.Direction.VERTICAL_DOWN);
        } else {
            this.labelRotate.setDirection(JLabelRotate.Direction.HORIZONTAL);
        }
    }

    public MultiSortTableCellHeaderRenderer() {
        this.labelRotate.setHorizontalAlignment(0);
        this.labelRotate.setHorizontalTextPosition(10);
        this.labelRotate.setDirection(JLabelRotate.Direction.HORIZONTAL);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader tableHeader = table.getTableHeader();
        Color fg = null;
        Color bg = null;
        Border border = null;
        Icon icon = null;
        if (hasFocus) {
            fg = UIManager.getColor("TableHeader.focusCellForeground");
            bg = UIManager.getColor("TableHeader.focusCellBackground");
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (fg == null) {
            fg = tableHeader.getForeground();
        }
        if (bg == null) {
            bg = tableHeader.getBackground();
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        if (!tableHeader.isPaintingForPrint() && table.getRowSorter() != null) {
            icon = this.getSortIcon(table, table.convertColumnIndexToModel(column));
        }
        this.labelRotate.setFont(tableHeader.getFont());
        this.labelRotate.setText(value != null && value != "" ? value.toString() : " ");
        this.labelRotate.setBorder(border);
        this.labelRotate.setIcon(icon);
        return this.labelRotate;
    }

    protected Icon getSortIcon(JTable table, int column) {
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        if (sortKeys == null || sortKeys.size() == 0) {
            return null;
        }
        int priority = 1;
        for (RowSorter.SortKey sortKey : sortKeys) {
            if (sortKey.getColumn() == column) {
                if (sortKey.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
                    return null;
                }
                this.sortIcon.setPriority(priority);
                this.sortIcon.setSortOrder(sortKey.getSortOrder());
                return this.sortIcon;
            }
            if (sortKey.getSortOrder().equals((Object)SortOrder.UNSORTED)) continue;
            ++priority;
        }
        return null;
    }

    static class JLabelRotate
    extends JLabel {
        private static final long serialVersionUID = 3179355145875424479L;
        private Direction direction;
        private boolean needsRotate;

        JLabelRotate() {
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        @Override
        public Dimension getSize() {
            if (!this.needsRotate) {
                return super.getSize();
            }
            Dimension size = super.getSize();
            switch (this.getDirection()) {
                case VERTICAL_DOWN: 
                case VERTICAL_UP: {
                    return new Dimension(size.height, size.width);
                }
            }
            return super.getSize();
        }

        @Override
        public int getHeight() {
            return this.getSize().height;
        }

        @Override
        public int getWidth() {
            return this.getSize().width;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D gr = (Graphics2D)g.create();
            switch (this.getDirection()) {
                case VERTICAL_UP: {
                    gr.translate(0.0, this.getSize().getHeight());
                    gr.transform(AffineTransform.getQuadrantRotateInstance(-1));
                    break;
                }
                case VERTICAL_DOWN: {
                    gr.transform(AffineTransform.getQuadrantRotateInstance(1));
                    gr.translate(0.0, -this.getSize().getWidth());
                    break;
                }
            }
            this.needsRotate = true;
            super.paintComponent(gr);
            this.needsRotate = false;
        }

        public static enum Direction {
            HORIZONTAL,
            VERTICAL_UP,
            VERTICAL_DOWN;

        }
    }
}

