/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.list;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.SortOrder;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicArrowButton;

class SortIcon
implements Icon,
SwingConstants {
    private int baseSize;
    private int direction;
    private BasicArrowButton iconRenderer;
    private String priority;

    public SortIcon(int size) {
        this.baseSize = size;
        this.iconRenderer = new BasicArrowButton(this.direction);
    }

    public void setPriority(Integer priority) {
        this.priority = priority.toString();
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.direction = sortOrder == SortOrder.ASCENDING ? 1 : 5;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.iconRenderer.paintTriangle(g, x + 2, y - 2, this.baseSize, this.direction, true);
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawString(this.priority, (float)(x + this.getIconWidth() + 3), (float)((double)(-g2d.getFontMetrics().getDescent() + 1) + g2d.getFontMetrics().getMaxCharBounds(g2d).getHeight()));
        }
    }

    @Override
    public int getIconWidth() {
        return this.baseSize + 3;
    }

    @Override
    public int getIconHeight() {
        return this.baseSize / 2;
    }
}

