/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.swing.viewers.list.InnerTableModel;
import ru.infor.beanviewer.swing.viewers.list.SwingTableRowSorter;

public class SwingExternalRowSorter<M extends TableModel>
extends SwingTableRowSorter<M> {
    List<RowSorter.SortKey> sortKeys = Collections.emptyList();
    TableWithModel<?> tm;
    boolean isExternalSorter = true;
    boolean changeSorter = false;

    public void changerowsorter(boolean newsorter) {
        if (newsorter != this.isExternalSorter) {
            this.changeSorter = true;
            int[] k = this.tm.getSelectedRows();
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            this.isExternalSorter = newsorter;
            this.setSortKeys(sortKeys);
            this.allRowsChanged();
            if (k != null && k.length > 0) {
                ArrayList<Integer> l = new ArrayList<Integer>();
                for (int kk : k) {
                    if (this.tm.list.size() <= kk) continue;
                    l.add(kk);
                }
                int[] kl = new int[l.size()];
                for (int i = 0; i < l.size(); ++i) {
                    kl[i] = (Integer)l.get(i);
                }
                this.tm.setSelectedRows(kl);
            }
            this.changeSorter = false;
        }
    }

    public SwingExternalRowSorter(M model, TableWithModel<?> tm) {
        super(model);
        this.tm = tm;
    }

    @Override
    public boolean isSortable(int column) {
        if (this.isExternalSorter) {
            TableModel m = (TableModel)this.getModel();
            if (m instanceof InnerTableModel) {
                return ((InnerTableModel)m).isSortable(column);
            }
            return true;
        }
        return super.isSortable(column);
    }

    @Override
    public void toggleSortOrder(int column) {
        this.tm.getViewer().getFactory().setCursor(1);
        if (this.isSortable(column) && this.isExternalSorter) {
            int sortIndex;
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
            }
            if (sortIndex == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                keys.add(sortKey);
            } else {
                RowSorter.SortKey new_key = this.toggle((RowSorter.SortKey)keys.get(sortIndex));
                if (new_key.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
                    keys.remove(sortIndex);
                } else {
                    keys.set(sortIndex, new_key);
                }
            }
            this.setSortKeys(keys);
        } else {
            super.toggleSortOrder(column);
        }
        this.tm.getViewer().getFactory().setCursor(0);
    }

    @Override
    public int convertRowIndexToModel(int index) {
        if (this.isExternalSorter) {
            return index;
        }
        return super.convertRowIndexToModel(index);
    }

    @Override
    public int convertRowIndexToView(int index) {
        if (this.isExternalSorter) {
            return index;
        }
        return super.convertRowIndexToView(index);
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        if (this.isExternalSorter) {
            List<RowSorter.SortKey> old = this.sortKeys;
            if (sortKeys != null && sortKeys.size() > 0) {
                int max = ((TableModel)this.getModel()).getColumnCount();
                for (RowSorter.SortKey sortKey : sortKeys) {
                    if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < max) continue;
                    throw new IllegalArgumentException("Invalid SortKey");
                }
                this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(sortKeys));
            } else {
                this.sortKeys = Collections.emptyList();
            }
            if (!this.sortKeys.equals(old)) {
                this.tm.setSortKey(this.sortKeys);
                this.fireSortOrderChanged();
            }
        } else {
            super.setSortKeys(sortKeys);
        }
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        if (this.isExternalSorter) {
            return this.sortKeys;
        }
        return super.getSortKeys();
    }

    @Override
    public int getViewRowCount() {
        if (this.isExternalSorter) {
            return this.getModelRowCount();
        }
        return super.getViewRowCount();
    }

    @Override
    public int getModelRowCount() {
        if (this.isExternalSorter) {
            return ((TableModel)this.getModel()).getRowCount();
        }
        return super.getModelRowCount();
    }

    @Override
    public void modelStructureChanged() {
        if (!this.isExternalSorter) {
            super.modelStructureChanged();
        }
    }

    @Override
    public void allRowsChanged() {
        if (!this.isExternalSorter) {
            super.allRowsChanged();
        }
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
        if (!this.isExternalSorter) {
            super.rowsInserted(firstRow, endRow);
        }
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
        if (!this.isExternalSorter) {
            super.rowsDeleted(firstRow, endRow);
        }
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
        if (!this.isExternalSorter) {
            super.rowsUpdated(firstRow, endRow);
        }
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
        if (!this.isExternalSorter) {
            super.rowsUpdated(firstRow, endRow, column);
        }
    }
}

