/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.list;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.bind.JAXBException;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.PropertyManager;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.swing.viewers.list.ColumnUIProperties;
import ru.infor.beanviewer.swing.viewers.list.InnerTableModel;
import ru.infor.beanviewer.swing.viewers.list.MultiSortTableCellHeaderRenderer;
import ru.infor.beanviewer.swing.viewers.list.SwingExternalRowSorter;
import ru.infor.beanviewer.swing.viewers.list.SwingTableRowSorter;
import ru.infor.beanviewer.swing.viewers.list.TableUIProperties;
import ru.infor.beanviewer.swing.viewers.list.UIColumnModelListener;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.AsyncList;
import ru.infor.beanviewer.viewer.list.DataChangedListenerFill;
import ru.infor.beanviewer.viewer.list.DataSelectionListener;
import ru.infor.beanviewer.viewer.list.ListTableCellViewer;
import ru.infor.beanviewer.viewer.list.ListTableEditor;
import ru.infor.beanviewer.viewer.list.ListTableRenderer;
import ru.infor.beanviewer.viewer.list.ListWithSelection;

public class SwingListTableModel
extends TableWithModel<JComponent>
implements DataChangedListenerFill,
DataSelectionListener,
RowSorterListener {
    JTable table = new JTable();
    private UIColumnModelListener columnListener;
    private boolean initProccessIsRunning;
    private MultiSortTableCellHeaderRenderer cellHeaderRenderer;
    TableUIProperties properties;

    @Override
    public void dndEnable(boolean enabled) {
        this.table.setDragEnabled(enabled);
    }

    @Override
    public void setDirection(String direction) {
        super.setDirection(direction);
        this.cellHeaderRenderer.setDirection(direction);
    }

    @Override
    public void setHeaderSize(String headerSize) {
        super.setHeaderSize(headerSize);
        if (headerSize != null && !"".equals(headerSize)) {
            this.table.getTableHeader().setPreferredSize(new Dimension(this.table.getTableHeader().getSize().width, Integer.parseInt(headerSize)));
        }
    }

    protected void setHeader() {
    }

    public SwingListTableModel(final BigContentViewer<JComponent> vie) {
        super(vie);
        this.setHeader();
        this.cellHeaderRenderer = new MultiSortTableCellHeaderRenderer();
        this.table.getTableHeader().setDefaultRenderer(this.cellHeaderRenderer);
        this.table.setSelectionMode(2);
        this.table.setIntercellSpacing(new Dimension(5, 1));
        this.readOnly = this.viewer.isReadOnly();
        this.notDefSelection = this.viewer.notDefSel;
        final JPopupMenu menu = new JPopupMenu();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SwingListTableModel.this.viewer.doubleClickCurrent();
                }
                if (e.getModifiers() == 4) {
                    if (!menu.isVisible()) {
                        menu.removeAll();
                        List<BeanViewerAction<ViewerContext>> list = vie.getPopupMenu();
                        if (list != null) {
                            for (BeanViewerAction<ViewerContext> bva : list) {
                                Action a = ((SwingFactory)vie.getFactory()).createAction(bva, null, null);
                                bva.setContext(vie.getViewerContext());
                                JMenuItem mi = new JMenuItem(a);
                                menu.add(mi);
                            }
                            int x = e.getX();
                            int y = e.getY();
                            menu.show(SwingListTableModel.this.table, x, y);
                            menu.repaint();
                        }
                    }
                } else {
                    menu.setVisible(false);
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    if (!menu.isVisible()) {
                        menu.removeAll();
                        List<BeanViewerAction<ViewerContext>> list = vie.getPopupMenu();
                        if (list != null) {
                            for (BeanViewerAction<ViewerContext> bva : list) {
                                Action a = ((SwingFactory)vie.getFactory()).createAction(bva, null, null);
                                bva.setContext(vie.getViewerContext());
                                JMenuItem mi = new JMenuItem(a);
                                menu.add(mi);
                            }
                            int x = e.getX();
                            int y = e.getY();
                            menu.show(SwingListTableModel.this.table, x, y);
                            menu.repaint();
                        }
                    }
                } else {
                    menu.setVisible(false);
                }
            }
        });
        if (!this.readOnly) {
            this.table.setCellSelectionEnabled(true);
            final Action cancel = this.table.getActionMap().get("cancel");
            this.table.getActionMap().put("cancel", new AbstractAction(){
                private static final long serialVersionUID = -2531338862340890015L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingListTableModel.this.canselCellEditor();
                    cancel.actionPerformed(e);
                }
            });
            this.table.getActionMap().put("startEditing", new AbstractAction(){
                private static final long serialVersionUID = -6333704380871964721L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int leadRow = SwingListTableModel.this.table.getSelectionModel().getLeadSelectionIndex();
                    int leadColumn = SwingListTableModel.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                    if (leadRow != -1 && leadColumn != -1 && !SwingListTableModel.this.table.isEditing()) {
                        SwingListTableModel.this.startEdit(SwingListTableModel.this.table.convertRowIndexToModel(leadRow));
                        SwingListTableModel.this.table.editCellAt(leadRow, leadColumn, e);
                    }
                }
            });
            final Action startEditing = this.table.getActionMap().get("startEditing");
            final Action entrAction = this.table.getActionMap().get("selectNextRowCell");
            this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "EnterActionOnTable");
            this.table.getActionMap().put("EnterActionOnTable", new AbstractAction(){
                private static final long serialVersionUID = 5519692762748660172L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SwingListTableModel.this.table.isEditing() || !SwingListTableModel.this.table.isCellEditable(SwingListTableModel.this.table.getSelectedRow(), SwingListTableModel.this.table.getSelectedColumn())) {
                        entrAction.actionPerformed(e);
                    } else {
                        startEditing.actionPerformed(e);
                    }
                }
            });
        }
        this.columnListener = new UIColumnModelListener(this);
        this.table.addPropertyChangeListener(new Listener1(this));
    }

    public void updateRowHeight() {
        if (this.getRowCount() > 0) {
            FontMetrics ff = this.table.getFontMetrics(this.table.getFont());
            this.table.setRowHeight(ff.getHeight() + this.table.getRowMargin());
        }
    }

    @Override
    public TableUIProperties getUIProperties() {
        int i;
        TableColumnModel cm = this.table.getColumnModel();
        if (this.properties == null) {
            this.properties = (TableUIProperties)this.viewer.getNewUiProperties();
            this.properties.setAutomaticWidthAjust(this.table.getAutoResizeMode() != 0);
            if (this.properties.getColumns() == null) {
                this.properties.setColumns(new HashMap<String, ColumnUIProperties>());
            }
            for (i = 0; i < cm.getColumnCount(); ++i) {
                if (this.properties.getColumns().get(this.getColumnName(i)) == null) {
                    this.properties.getColumns().put(this.getColumnName(i), new ColumnUIProperties());
                    this.properties.getColumns().get(this.getColumnName(i)).setVisible(true);
                }
                this.properties.getColumns().get(this.getColumnName(i)).setWidth(cm.getColumn(this.table.convertColumnIndexToView(i)).getWidth());
                this.properties.getColumns().get(this.getColumnName(i)).setOrder(this.table.convertColumnIndexToView(i));
                ListTableRenderer r = (ListTableRenderer)cm.getColumn(this.table.convertColumnIndexToView(i)).getCellRenderer();
                if (r == null) continue;
                FieldViewer<JComponent> fv = r.getFieldViewer();
                this.properties.getColumns().get(this.getColumnName(i)).setCellViewer(fv);
                if (!fv.getClass().isAssignableFrom(ActionButton.class)) continue;
                this.properties.getColumns().get(this.getColumnName(i)).setVisible(false);
            }
        }
        for (i = 0; i < cm.getColumnCount(); ++i) {
            ListTableRenderer r;
            int k;
            ColumnUIProperties p = this.properties.getColumns().get(this.getColumnName(i));
            if (p == null) {
                p = new ColumnUIProperties();
                p.setName(this.getColumnName(i));
                p.setOrder(this.table.convertColumnIndexToView(i));
                p.setVisible(true);
                p.setWidth(cm.getColumn(this.table.convertColumnIndexToView(i)).getWidth());
                this.properties.getColumns().put(p.getName(), p);
                ListTableRenderer r2 = (ListTableRenderer)cm.getColumn(this.table.convertColumnIndexToView(i)).getCellRenderer();
                if (r2 != null) {
                    FieldViewer<JComponent> fv = r2.getFieldViewer();
                    this.properties.getColumns().get(this.getColumnName(i)).setCellViewer(fv);
                    if (fv.getClass().isAssignableFrom(ActionButton.class)) {
                        p.setVisible(false);
                    }
                }
            }
            if ((k = this.table.convertColumnIndexToView(i)) < 0 || (r = (ListTableRenderer)cm.getColumn(k).getCellRenderer()) == null) continue;
            FieldViewer<JComponent> fv = r.getFieldViewer();
            this.properties.getColumns().get(this.getColumnName(i)).setCellViewer(fv);
            p.setCellViewer(fv);
        }
        return this.properties;
    }

    @Override
    public TableUIProperties getDefaultUIProperties() {
        this.properties = new TableUIProperties();
        this.properties.setAutomaticWidthAjust(false);
        if (this.properties.getColumns() == null) {
            this.properties.setColumns(new HashMap<String, ColumnUIProperties>());
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.properties.getColumns().get(this.getColumnName(i)) == null) {
                this.properties.getColumns().put(this.getColumnName(i), new ColumnUIProperties());
                this.properties.getColumns().get(this.getColumnName(i)).setVisible(true);
            }
            this.properties.getColumns().get(this.getColumnName(i)).setWidth(250);
            this.properties.getColumns().get(this.getColumnName(i)).setOrder(i);
            FieldViewer fv = this.getFieldViewer(i);
            this.properties.getColumns().get(this.getColumnName(i)).setCellViewer(fv);
            if (!fv.getClass().isAssignableFrom(ActionButton.class)) continue;
            this.properties.getColumns().get(this.getColumnName(i)).setVisible(false);
        }
        return this.properties;
    }

    @Override
    public void addActionOnSelectionListener(final BeanViewerAction<AbstractContext<?>> bva) {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    bva.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public void canselCellEditor() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    public void fireTableDataChanged() {
        int i;
        int[] s;
        int k;
        if (this.table.getSelectedRow() >= this.list.size()) {
            this.clearSelection();
        }
        if ((k = this.table.getSelectedColumn()) >= 0) {
            k = this.table.convertColumnIndexToModel(k);
        }
        if ((s = this.table.getSelectedRows()).length > 0) {
            this.selTable = new int[s.length];
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (i = 0; i < s.length; ++i) {
                if (s[i] >= this.table.getRowCount()) continue;
                l.add(this.table.getRowSorter().convertRowIndexToModel(s[i]));
            }
            this.selTable = new int[l.size()];
            for (i = 0; i < l.size(); ++i) {
                this.selTable[i] = (Integer)l.get(i);
            }
        }
        ((DefaultTableModel)this.table.getModel()).fireTableDataChanged();
        if (!this.table.getCellSelectionEnabled()) {
            if (!this.updateSelection()) {
                if (this.notDefSelection) {
                    this.table.clearSelection();
                } else if (this.table.getSelectedRowCount() == 0 && this.table.getRowCount() > 0 && this.selTable != null && this.selTable.length > 0) {
                    try {
                        int ss;
                        for (ss = this.table.getRowSorter().convertRowIndexToView(this.selTable[0]); ss >= this.table.getRowCount(); --ss) {
                        }
                        if (ss >= 0) {
                            this.table.setRowSelectionInterval(ss, ss);
                            for (i = 1; i < this.selTable.length; ++i) {
                                if (this.selTable[i] < 0 || this.list.size() <= this.selTable[0]) continue;
                                int s1 = this.table.getRowSorter().convertRowIndexToView(this.selTable[i]);
                                this.table.addRowSelectionInterval(s1, s1);
                                ss = s1;
                            }
                            this.initProccessIsRunning = true;
                            this.table.scrollRectToVisible(this.table.getCellRect(ss, 0, false));
                            this.initProccessIsRunning = false;
                        }
                    }
                    catch (Exception ss) {}
                }
            }
        } else if (this.table.getRowCount() > 0 && this.selTable != null && this.selTable.length >= 0) {
            int ss;
            for (ss = this.table.getRowSorter().convertRowIndexToView(this.selTable[0]); ss >= this.table.getRowCount(); --ss) {
            }
            if (ss >= 0) {
                this.table.changeSelection(ss, k < 0 ? 0 : this.table.convertColumnIndexToView(k), false, false);
                if (this.bp != null) {
                    this.bp.setSelectRow(this.selTable[0]);
                }
            }
        }
        this.updateRowHeight();
    }

    @Override
    public void fireTableRowsUpdated(int ind) {
        if (ind >= 0) {
            int i = this.table.getRowSorter().convertRowIndexToView(ind);
            ((DefaultTableModel)this.table.getModel()).fireTableRowsUpdated(i, i);
            this.table.setRowSelectionInterval(i, i);
            this.table.scrollRectToVisible(this.table.getCellRect(i, 0, false));
            this.selTable = new int[]{ind};
        }
    }

    @Override
    public int getEditingRow() {
        return this.table.getEditingRow();
    }

    @Override
    public int[] getSelectedRowsTable() {
        int[] selected = this.table.getSelectedRows();
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (selected != null && selected.length > 0) {
            for (int i = 0; i < selected.length; ++i) {
                if (this.list.size() <= selected[i]) continue;
                l.add(this.table.getRowSorter().convertRowIndexToModel(selected[i]));
            }
        }
        int[] k = new int[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            k[i] = (Integer)l.get(i);
        }
        return k;
    }

    @Override
    public void setSelectedRowsTable(int[] i) {
        if (i.length > 0) {
            int k = this.table.getRowSorter().convertRowIndexToView(i[0]);
            this.table.setRowSelectionInterval(k, k);
            for (int ii = 1; ii < i.length; ++ii) {
                int s = this.table.getRowSorter().convertRowIndexToView(i[ii]);
                this.table.addRowSelectionInterval(s, s);
                k = s;
            }
            this.initProccessIsRunning = true;
            this.table.scrollRectToVisible(this.table.getCellRect(k, 0, false));
            this.initProccessIsRunning = false;
        }
    }

    @Override
    public Class getTableCellViewerClass() {
        return ListTableCellViewer.class;
    }

    @Override
    public JComponent getTableComponent() {
        return this.table;
    }

    public void updateUIProperties() {
        if (!this.initProccessIsRunning) {
            int i;
            TableColumnModel cm = this.table.getColumnModel();
            if (this.properties == null) {
                this.properties = (TableUIProperties)this.viewer.getUIProperties();
            } else {
                if (this.properties.getColumns() == null) {
                    this.properties.setColumns(new HashMap<String, ColumnUIProperties>());
                }
                for (i = 0; i < cm.getColumnCount(); ++i) {
                    if (this.properties.getColumns().get(this.getColumnName(i)) != null) continue;
                    this.properties.getColumns().put(this.getColumnName(i), new ColumnUIProperties());
                    this.properties.getColumns().get(this.getColumnName(i)).setVisible(true);
                }
            }
            for (i = 0; i < cm.getColumnCount(); ++i) {
                TableCellRenderer renderer = cm.getColumn(this.table.convertColumnIndexToView(i)).getCellRenderer();
                if (renderer != null) {
                    this.properties.getColumns().get(this.getColumnName(i)).setCellViewer(((ListTableRenderer)renderer).getFieldViewer());
                }
                this.properties.getColumns().get(this.getColumnName(i)).setOrder(this.table.convertColumnIndexToView(i));
                if (!this.properties.getColumns().get(this.getColumnName(i)).isVisible()) continue;
                this.properties.getColumns().get(this.getColumnName(i)).setWidth(cm.getColumn(this.table.convertColumnIndexToView(i)).getWidth());
            }
            this.viewer.setUIProperties(this.properties);
            if (PropertyManager.getSaver() != null) {
                try {
                    PropertyManager.getSaver().save(this.viewer.getKey(), PropertyManager.propertiesToXML(this.properties));
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void setViewerToEditor(int i, FieldViewer<JComponent> fv) {
        this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(i)).setCellEditor(new ListTableEditor(fv));
    }

    @Override
    public void setViewerToRenderer(int i, FieldViewer<JComponent> fv) {
        super.setViewerToRenderer(i, fv);
        this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(i)).setCellRenderer(new ListTableRenderer(fv, this));
    }

    @Override
    public boolean stopCellEditor() {
        if (this.table.getCellEditor() != null) {
            return this.table.getCellEditor().stopCellEditing();
        }
        return false;
    }

    public void setSorter() {
        if (this.list instanceof AsyncList) {
            this.table.setRowSorter(new SwingExternalRowSorter<InnerTableModel>((InnerTableModel)this.table.getModel(), this));
            ((AsyncList)this.list).addDataChangedListenerFill(this);
        } else {
            this.table.setRowSorter(new SwingTableRowSorter<InnerTableModel>((InnerTableModel)this.table.getModel()));
        }
        this.table.getRowSorter().addRowSorterListener(this);
    }

    @Override
    public void updateModel(List<Object> list, Class<?> item, UIFactory<JComponent> factory, PanelContext pc, TableUIProperties properties, boolean containClassWasChanged, String keyContentProperties) {
        super.updateModel(list, item, factory, pc, properties, containClassWasChanged, keyContentProperties);
        if (containClassWasChanged) {
            InnerTableModel tcm = new InnerTableModel(this);
            this.table.setModel(tcm);
            this.table.getColumnModel().removeColumnModelListener(this.columnListener);
            this.setUIProperties(properties);
            this.table.getColumnModel().addColumnModelListener(this.columnListener);
        }
        this.setSorter();
        if (list instanceof AsyncList && this.table.getRowSorter() instanceof SwingExternalRowSorter) {
            ((AsyncList)list).addDataChangedListenerFill(this);
        }
        if (list instanceof ListWithSelection) {
            ((ListWithSelection)((Object)list)).addActionListener(this);
        }
        this.fireTableDataChanged();
        List<TableWithModel.SortKeyForTable> ls = this.getSorters();
        if (ls != null) {
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.table.getRowSorter().getSortKeys());
            Collections.sort(ls);
            for (TableWithModel.SortKeyForTable skt : ls) {
                RowSorter.SortKey sk = null;
                if (skt.getSorter().toUpperCase().equals("ASCENDING")) {
                    sk = new RowSorter.SortKey(skt.getColumn(), SortOrder.ASCENDING);
                } else if (skt.getSorter().toUpperCase().equals("DESCENDING")) {
                    sk = new RowSorter.SortKey(skt.getColumn(), SortOrder.DESCENDING);
                }
                if (sk == null) continue;
                keys.add(sk);
            }
            this.setSortKeys(keys);
        }
    }

    @Override
    public void setUIProperties(Object properties) {
        this.initProccessIsRunning = true;
        this.properties = (TableUIProperties)properties;
        if (this.properties != null) {
            this.table.setAutoResizeMode(this.properties.isAutomaticWidthAjust() ? 4 : 0);
            ArrayList<String> needRemove = new ArrayList<String>();
            HashMap<String, Integer> orders = new HashMap<String, Integer>();
            if (this.properties.getColumns() != null) {
                ArrayList<String> l = new ArrayList<String>(this.properties.getColumns().keySet());
                for (String key : l) {
                    ColumnUIProperties cp = this.properties.getColumns().get(key);
                    boolean exist = true;
                    TableColumn tc = null;
                    try {
                        tc = this.table.getColumn(key);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (tc != null) {
                        if (cp.isVisible()) {
                            tc.setResizable(true);
                            tc.setMinWidth(15);
                            tc.setMaxWidth(this.table.getMaximumSize().width);
                            tc.setPreferredWidth(cp.getWidth());
                            tc.setWidth(cp.getWidth());
                            orders.put(key, cp.getOrder());
                        } else {
                            tc.setPreferredWidth(0);
                            tc.setWidth(0);
                            tc.setMinWidth(0);
                            tc.setMaxWidth(0);
                            tc.setResizable(false);
                        }
                        exist = false;
                    }
                    if (!exist) continue;
                    needRemove.add(key);
                }
                for (String remove : needRemove) {
                    this.properties.getColumns().remove(remove);
                }
                for (String key : orders.keySet()) {
                    int old = this.table.getColumnModel().getColumnIndex(key);
                    if ((Integer)orders.get(key) >= this.table.getColumnCount()) continue;
                    this.table.getColumnModel().moveColumn(old, (Integer)orders.get(key));
                }
            }
        } else {
            this.table.setAutoResizeMode(4);
        }
        this.initProccessIsRunning = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateSelection() {
        block7: {
            if (this.list instanceof ListWithSelection) {
                if (((ListWithSelection)((Object)this.list)).getTypeSelection() == 1) {
                    Integer sel = ((ListWithSelection)((Object)this.list)).getSelection();
                    if (sel != null && sel >= 0 && this.list.size() > sel) {
                        int s = this.table.getRowSorter().convertRowIndexToView(sel);
                        s = this.getExtendedObject().getRowInTablePosition(s);
                        this.table.setRowSelectionInterval(s, s);
                        this.table.scrollRectToVisible(this.table.getCellRect(s, 0, false));
                        this.viewer.actionOnSelect__();
                        return true;
                    }
                    break block7;
                } else {
                    Integer[] sel = ((ListWithSelection)((Object)this.list)).getSelections();
                    if (sel.length > 0 && sel[0] != null && sel[0] >= 0 && this.list.size() > sel[0]) {
                        int s = this.table.getRowSorter().convertRowIndexToView(sel[0]);
                        this.table.setRowSelectionInterval(s, s);
                        for (int i = 1; i < sel.length; ++i) {
                            if (sel[i] == null || sel[i] < 0 || this.list.size() <= sel[0]) continue;
                            int s1 = this.table.getRowSorter().convertRowIndexToView(sel[i]);
                            this.table.addRowSelectionInterval(s1, s1);
                            s = s1;
                        }
                        this.initProccessIsRunning = true;
                        this.table.scrollRectToVisible(this.table.getCellRect(s, 0, false));
                        this.initProccessIsRunning = false;
                    }
                    this.viewer.actionOnSelect__();
                    return true;
                }
            }
            if (this.notDefSelection) {
                this.table.clearSelection();
                this.viewer.actionOnSelect__();
                return true;
            }
        }
        this.viewer.actionOnSelect__();
        return false;
    }

    @Override
    public void clearSelection() {
        this.table.clearSelection();
    }

    @Override
    public void dataChanged(boolean newfill) {
        if (this.getExtendedObject().canInnerSort()) {
            ((SwingExternalRowSorter)this.table.getRowSorter()).changerowsorter(!newfill);
        }
    }

    @Override
    public void changeSelection() {
        this.updateSelection();
    }

    @Override
    public List<?> getSortKeys() {
        if (this.table != null && this.table.getRowSorter() != null) {
            return this.table.getRowSorter().getSortKeys();
        }
        return null;
    }

    @Override
    public void setSortKeys(List<?> keys) {
        if (this.table != null && this.table.getRowSorter() != null) {
            this.table.getRowSorter().setSortKeys(keys);
            if (this.table.getModel().getRowCount() > 0) {
                this.table.getRowSorter().allRowsChanged();
            }
        }
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        if (e.getType().equals((Object)RowSorterEvent.Type.SORTED)) {
            this.viewer.sorterChanged();
        }
    }

    public static class Listener1
    implements TableColumnModelListener,
    PropertyChangeListener {
        SwingListTableModel model;
        JTable table;

        public Listener1(SwingListTableModel model) {
            this.model = model;
            this.table = (JTable)model.getTableComponent();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("font")) {
                this.model.updateRowHeight();
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

