/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.list;

import java.util.ArrayList;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SwingTableRowSorter<M extends TableModel>
extends TableRowSorter<M> {
    public SwingTableRowSorter(M model) {
        super(model);
    }

    @Override
    public void toggleSortOrder(int column) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            int sortIndex;
            ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
            }
            if (sortIndex == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                keys.add(sortKey);
            } else {
                RowSorter.SortKey new_key = this.toggle((RowSorter.SortKey)keys.get(sortIndex));
                if (new_key.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
                    keys.remove(sortIndex);
                } else {
                    keys.set(sortIndex, new_key);
                }
            }
            this.setSortKeys(keys);
        }
    }

    protected RowSorter.SortKey toggle(RowSorter.SortKey key) {
        if (key.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
        }
        if (key.getSortOrder() == SortOrder.DESCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.UNSORTED);
        }
        return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }
}

