/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.tree.Tree;
import ru.infor.beanviewer.swing.dnd.UIGeneratorTransferHandler;
import ru.infor.beanviewer.swing.viewers.tree.SwingModel;
import ru.infor.beanviewer.swing.viewers.tree.SwingTreeDNDAdaptor;
import ru.infor.beanviewer.swing.viewers.tree.TreeNode;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.AbstractContext;

public class SwingTreeForModel
implements Tree<JComponent> {
    JTree tree = new JTree();
    private FieldViewer<?> fw;

    public SwingTreeForModel(FieldViewer<?> fw) {
        this.fw = fw;
    }

    public void setRootVisible(boolean rootVisible) {
        this.tree.setRootVisible(rootVisible);
    }

    public void dndEnable(boolean enabled) {
        if (enabled) {
            this.tree.setTransferHandler(new UIGeneratorTransferHandler(new SwingTreeDNDAdaptor(this.fw)));
            this.tree.setDragEnabled(true);
        } else {
            this.tree.setTransferHandler(null);
            this.tree.setDragEnabled(false);
        }
    }

    @Override
    public void addToSelection(List<?> obj) {
        TreePath parentPath = this.tree.getSelectionPath();
        TreeNode parent = parentPath == null ? (TreeNode)this.tree.getModel().getRoot() : (TreeNode)parentPath.getLastPathComponent();
        if (parent == null) {
            this.updateRoot(obj.get(0));
        } else {
            for (Object object : obj) {
                parent.addChild((TreeNode)object);
            }
        }
    }

    @Override
    public Object getRootValue() {
        return this.tree.getModel().getRoot();
    }

    @Override
    public Object getSelected() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return this.tree.getSelectionPath().getLastPathComponent();
    }

    @Override
    public List<Object> getSelection() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (TreePath tp : this.tree.getSelectionPaths()) {
            ret.add(tp.getLastPathComponent());
        }
        return ret;
    }

    @Override
    public JComponent getTreeComponent() {
        return this.tree;
    }

    @Override
    public List<Object> removeSelected() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths.length > 0) {
            ArrayList<Object> removed = new ArrayList<Object>(paths.length);
            for (TreePath path : paths) {
                TreeNode obj = (TreeNode)path.getLastPathComponent();
                removed.add(obj);
                obj.remove();
            }
            return removed;
        }
        return null;
    }

    @Override
    public void setChangeValueAction(final BeanViewerAction changeAction) {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                changeAction.actionPerformed(e);
            }
        });
    }

    @Override
    public void setValueAndSelect(Object value) {
        TreeNode root = (TreeNode)value;
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        while (root != null) {
            path.add(0, root);
            TreeNode parent = root.parent;
            if (parent == null) break;
            root = parent;
        }
        this.updateRoot(root);
        this.tree.setSelectionPath(new TreePath(path.toArray()));
        this.tree.revalidate();
    }

    @Override
    public void setSelection(Object value) {
        if (value == null) {
            this.tree.clearSelection();
        } else {
            TreeNode root = (TreeNode)value;
            ArrayList<TreeNode> path = new ArrayList<TreeNode>();
            while (root != null) {
                path.add(0, root);
                TreeNode parent = root.parent;
                if (parent == null) break;
                root = parent;
            }
            TreePath p = new TreePath(path.toArray());
            this.tree.setSelectionPath(p);
            this.tree.revalidate();
            this.tree.scrollPathToVisible(p);
        }
    }

    @Override
    public void updateRoot(Object value) {
        SwingModel model = new SwingModel((TreeNode)value);
        this.tree.setModel(model);
    }

    @Override
    public void updateUIForSelectedObject() {
    }

    @Override
    public void addActionOnSelectionListener(final BeanViewerAction<AbstractContext<?>> bva) {
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                bva.actionPerformed(null);
            }
        });
    }
}

