/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.swing.viewers.tree;

import java.util.Arrays;
import java.util.List;
import ru.infor.beanviewer.swing.viewers.tree.StructureChangeEvent;
import ru.infor.beanviewer.swing.viewers.tree.StructureChangeListener;

public abstract class TreeNode
implements Comparable<TreeNode> {
    protected List<TreeNode> children;
    private StructureChangeListener listener;
    protected TreeNode parent;

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode addChild(TreeNode child) {
        this.initNewItem(child);
        child = this.addChildToPersistence(child);
        if (this.children == null) {
            this.children = this.getChildren();
        }
        this.children.add(child);
        StructureChangeEvent e = new StructureChangeEvent(this.getPath(), 3);
        this.listener.structureChange(e);
        return child;
    }

    public abstract TreeNode addChildToPersistence(TreeNode var1);

    public Object getChild(int index) {
        if (this.children == null) {
            this.children = this.getChildren();
        }
        return this.children.get(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            this.children = this.getChildren();
        }
        return this.children.size();
    }

    private List<TreeNode> getChildren() {
        List<TreeNode> ret = this.getChildrenFromPersistence();
        for (TreeNode node : ret) {
            this.initNewItem(node);
        }
        return ret;
    }

    public abstract List<TreeNode> getChildrenFromPersistence();

    protected Object[] getPath() {
        Object[] parentPath = this.parent != null ? this.parent.getPath() : new Object[]{};
        Object[] ret = Arrays.copyOf(parentPath, parentPath.length + 1);
        ret[ret.length - 1] = this;
        return ret;
    }

    private void initNewItem(TreeNode node) {
        node.setParent(this);
        node.setStructureChangeListener(this.listener);
    }

    public boolean isLeaf() {
        if (this.children == null) {
            this.children = this.getChildren();
        }
        return this.children == null || this.children.size() == 0;
    }

    public void remove() {
        this.removeFromPersistence();
        this.parent.remove(this);
    }

    public void remove(TreeNode item) {
        if (this.children != null) {
            this.children.remove(item);
        }
        StructureChangeEvent e = new StructureChangeEvent(this.getPath(), 3);
        this.listener.structureChange(e);
    }

    public abstract void removeFromPersistence();

    protected void setParent(TreeNode treeNode) {
        this.parent = treeNode;
    }

    public StructureChangeListener getStructureChangeListener() {
        return this.listener;
    }

    public void setStructureChangeListener(StructureChangeListener l) {
        this.listener = l;
        if (this.children != null) {
            for (TreeNode node : this.children) {
                node.setStructureChangeListener(this.listener);
            }
        }
    }

    @Override
    public int compareTo(TreeNode o) {
        if (o == null) {
            return 1;
        }
        return this.toString().compareTo(o.toString());
    }
}

