/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.validator;

import java.text.DateFormat;
import java.util.Date;
import ru.infor.beanviewer.validator.Validator;

public class DateValidator
extends Validator {
    private static final String EARLER = "\u0420\u0430\u043d\u0435\u0435";
    private static final String LATER = "\u041f\u043e\u0437\u0434\u043d\u0435\u0435";
    private static final String INTERVAL = "\u0412 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u0434\u0430\u0442";
    private static DateFormat df = DateFormat.getDateTimeInstance();
    private static String[] names = new String[]{"\u0420\u0430\u043d\u0435\u0435", "\u041f\u043e\u0437\u0434\u043d\u0435\u0435", "\u0412 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u0434\u0430\u0442"};

    @Override
    public String[] getNames() {
        return names;
    }

    @Override
    public boolean validate(String parameters, String name) {
        try {
            Date val = (Date)this.getBeanViewerActionContext().getPresentator().getViewer().getValue();
            String w = parameters.replace('-', ':');
            if (w.split(" ").length < 2) {
                w = w + " 0:0:0";
            }
            if (name.equals(EARLER)) {
                Date when = df.parse(w);
                return val.before(when);
            }
            if (name.equals(LATER)) {
                Date when = df.parse(w);
                return val.after(when);
            }
            if (name.equals(INTERVAL)) {
                String[] pars = parameters.split(";");
                String w1 = pars[0].replace('-', ':');
                if (w1.split(" ").length < 2) {
                    w1 = w1 + " 0:0:0";
                }
                Date when1 = df.parse(w1);
                String w2 = pars[1].replace('-', ':');
                if (w2.split(" ").length < 2) {
                    w2 = w2 + " 0:0:0";
                }
                Date when2 = df.parse(w2);
                return val.after(when1) && val.before(when2);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

