/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.validator;

import java.util.HashMap;
import ru.infor.beanviewer.validator.ClassNameValidator;
import ru.infor.beanviewer.validator.DateValidator;
import ru.infor.beanviewer.validator.FileValidator;
import ru.infor.beanviewer.validator.IsNullValidator;
import ru.infor.beanviewer.validator.LengthValidator;
import ru.infor.beanviewer.validator.MinMax;
import ru.infor.beanviewer.validator.RegexpValidator;
import ru.infor.beanviewer.validator.ValidatorDatePeriod;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public abstract class Validator {
    private ViewerContext bvac;
    private static HashMap<String, Class<? extends Validator>> validators;

    public abstract String[] getNames();

    public abstract boolean validate(String var1, String var2);

    public void setBeanViewerActionContext(ViewerContext bvac) {
        this.bvac = bvac;
    }

    public ViewerContext getBeanViewerActionContext() {
        return this.bvac;
    }

    public static Class<? extends Validator> getValidator(String name) {
        return validators.get(name);
    }

    public static boolean register(Class<? extends Validator> vc) {
        if (validators == null) {
            validators = new HashMap();
        }
        try {
            Validator v = vc.newInstance();
            for (String name : v.getNames()) {
                validators.put(name, vc);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        Validator.register(LengthValidator.class);
        Validator.register(MinMax.class);
        Validator.register(RegexpValidator.class);
        Validator.register(DateValidator.class);
        Validator.register(IsNullValidator.class);
        Validator.register(ClassNameValidator.class);
        Validator.register(FileValidator.class);
        Validator.register(ValidatorDatePeriod.class);
    }
}

