/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.AbstractContext;

public class AsyncBVA<E, T extends AbstractContext<?>>
extends BeanViewerAction<T> {
    private BiConsumer<E, T> success;
    private BiFunction<Object, T, E> action;
    private BiConsumer<Throwable, T> fail;
    private Runnable before;
    private Runnable after;

    public AsyncBVA() {
    }

    public AsyncBVA(BiFunction<Object, T, E> action, BiConsumer<E, T> success, BiConsumer<Throwable, T> fail) {
        this.success = success;
        this.action = action;
        this.fail = fail;
    }

    public void setActions(BiFunction<Object, T, E> action, BiConsumer<E, T> success, BiConsumer<Throwable, T> fail) {
        this.success = success;
        this.fail = fail;
        this.action = action;
    }

    @Override
    public void actionPerformed(Object message) {
        if (this.before != null) {
            CompletableFuture.runAsync(this.before);
        }
        CompletionStage act = CompletableFuture.supplyAsync(() -> this.action.apply(message, this.getContext())).handle((v, e) -> {
            if (e != null && this.fail != null) {
                this.fail.accept((Throwable)e, (Throwable)this.getContext());
            } else if (this.success != null) {
                this.success.accept(v, this.getContext());
            }
            return "";
        });
        if (this.after != null) {
            ((CompletableFuture)act).thenRun(this.after);
        }
    }

    public void setBeforeAndAfterActions(Runnable before, Runnable after) {
        this.before = before;
        this.after = after;
    }
}

