/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.util.Collection;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.ComplexObjectTableCellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ActionID;

public class ComplexObjectViewer<T>
extends FieldViewer<T>
implements SwingItem {
    T button;
    Object value;

    @Override
    public void update(Object value, ActionID id) {
        this.setValue(value);
    }

    public ComplexObjectViewer(UIFactory<T> factory) {
        super(factory);
    }

    protected String getKeyView() {
        return "";
    }

    public BeanViewerAction<ViewerContext> getActionForButton() {
        BeanViewerAction<ViewerContext> bva = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                if (ComplexObjectViewer.this.value == null) {
                    try {
                        ComplexObjectViewer.this.value = ComplexObjectViewer.this.getContentClass().newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (ComplexObjectViewer.this.value != null) {
                    ComplexObjectViewer.this.getFactory().newPage(ComplexObjectViewer.this.getContentClass(), ComplexObjectViewer.this.value.getClass(), ComplexObjectViewer.this.value, ComplexObjectViewer.this.getViewerContext(), ComplexObjectViewer.this.getKeyView());
                }
            }
        };
        bva.setContext(this.getViewerContext());
        return bva;
    }

    private T createButton(String name, String icon) {
        BeanViewerAction<ViewerContext> bva = this.getActionForButton();
        if (bva.getName() == null) {
            bva.setName(name);
        }
        if (bva.getIcon() == null) {
            bva.setIcon(icon);
        }
        return this.getFactory().getAction(bva, null);
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        if (this.button == null) {
            this.setValue(this.getValue());
        }
        return this.button;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.isEditable() != editable) {
            super.setEditable(editable);
            this.setValue(this.getValue());
        }
    }

    @Override
    public void setValue(Object object) {
        String name;
        this.value = object;
        if (this.value != null && !this.value.getClass().equals(this.getContentClass()) && !Collection.class.isAssignableFrom(this.value.getClass())) {
            this.setContentClass(this.value.getClass());
        }
        String string = name = this.value == null ? "\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d" : this.getNameButton(this.value);
        if (this.button == null) {
            this.button = this.isEditable() ? this.createButton(name, null) : this.getFactory().getLabel(name);
        }
        this.getFactory().setTextToComponent(this.button, name);
    }

    @Override
    public Class getTableCellViewerClass() {
        return ComplexObjectTableCellViewer.class;
    }

    protected String getNameButton(Object value) {
        return value.toString();
    }

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
    }
}

