/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import ru.infor.beanviewer.core.DefaultViewer;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.FilePathTableSellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class FilePathViewer<T>
extends DefaultViewer<T> {
    private String[] exts = null;
    private String[] typs = null;
    boolean appFile = false;

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("extension")) {
            this.exts = value.split(",");
        }
        if (key.toLowerCase().equals("type")) {
            this.typs = value.split(",");
        }
        if (key.toLowerCase().equals("appfile")) {
            this.appFile = Boolean.parseBoolean(value);
        }
        super.setPropertyField(key, value);
    }

    public FilePathViewer(UIFactory<T> factory) {
        super(factory);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        Object comp = super.getComponent(isSelected, hasFocus);
        Object p = this.getFactory().getPanel();
        BeanViewerAction<ViewerContext> bva = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                FileFilter ff = null;
                if (FilePathViewer.this.exts != null) {
                    ff = new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            for (String ext : FilePathViewer.this.exts) {
                                if (!f.getName().endsWith("." + ext)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public String getDescription() {
                            return null;
                        }
                    };
                }
                int type = 2;
                if (FilePathViewer.this.typs != null) {
                    boolean file = false;
                    boolean dir = false;
                    for (String t : FilePathViewer.this.typs) {
                        if (t.trim().toLowerCase().equals("file")) {
                            file = true;
                        }
                        if (!t.trim().toLowerCase().equals("directory")) continue;
                        dir = true;
                    }
                    if (file && dir) {
                        type = 2;
                    } else if (file) {
                        type = 0;
                    } else if (dir) {
                        type = 1;
                    }
                }
                String fn = (String)FilePathViewer.this.getValue();
                File dest = FilePathViewer.this.getFactory().runFileChooser(fn == null || fn.equals("") ? (FilePathViewer.this.appFile ? new File(".") : null) : new File(fn), type, ff);
                if (dest != null) {
                    FilePathViewer.this.setValue(dest.getAbsolutePath());
                }
                FilePathViewer.this.changeActionAllPerformed(null);
            }
        };
        bva.setName("\u0412\u044b\u0431\u0440\u0430\u0442\u044c");
        Object btn = this.getFactory().getAction(bva, null);
        this.getFactory().putObjectToContainer(comp, p, "growx");
        if (this.isEditable()) {
            this.getFactory().putObjectToContainer(btn, p, "growprio 0");
        }
        return p;
    }

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return FilePathTableSellViewer.class;
    }
}

