/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;

public class ImageViewer
extends FieldViewer<JComponent>
implements SwingItem {
    Image img = null;
    JButton l;
    JFileChooser fc = new JFileChooser();
    ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (0 == ImageViewer.this.fc.showDialog(ImageViewer.this.l, "\u0412\u044b\u0431\u043e\u0440 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f")) {
                try {
                    ImageViewer.this.setValue(ImageIO.read(ImageViewer.this.fc.getSelectedFile()));
                    ImageViewer.this.changeActionAllPerformed(null);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    };
    boolean added = false;

    public ImageViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.l = new JButton(){
            private static final long serialVersionUID = 5921190133212204193L;

            @Override
            protected void paintComponent(Graphics g) {
                if (ImageViewer.this.img != null && g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    double x_scale = (double)g2d.getClipBounds().width / (double)ImageViewer.this.img.getWidth(null);
                    double y_scale = (double)g2d.getClipBounds().height / (double)ImageViewer.this.img.getHeight(null);
                    double scale = Math.min(x_scale, y_scale);
                    double tx = ((double)g2d.getClipBounds().width - (double)ImageViewer.this.img.getWidth(null) * scale) / 2.0;
                    double ty = ((double)g2d.getClipBounds().height - (double)ImageViewer.this.img.getHeight(null) * scale) / 2.0;
                    AffineTransform at = AffineTransform.getTranslateInstance(tx, ty);
                    at.concatenate(AffineTransform.getScaleInstance(scale, scale));
                    g2d.drawImage(ImageViewer.this.img, at, null);
                }
            }
        };
        this.l.setPreferredSize(new Dimension(200, 200));
        this.l.setFocusPainted(false);
        this.fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String r = f.getName().toLowerCase();
                return f.isDirectory() || r.endsWith(".jpg") || r.endsWith(".jpeg") || r.endsWith(".tif") || r.endsWith(".tiff") || r.endsWith(".bmp") || r.endsWith(".png") || r.endsWith(".gif");
            }

            @Override
            public String getDescription() {
                return "\u0424\u0430\u0439\u043b\u044b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439";
            }
        });
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.l;
    }

    @Override
    public Object getValue() {
        return this.img;
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (editable) {
            if (!this.added) {
                this.l.addActionListener(this.al);
            }
        } else {
            this.l.removeActionListener(this.al);
        }
    }

    @Override
    public void setValue(Object object) {
        this.img = object != null ? (Image)object : null;
        this.l.paintImmediately(0, 0, this.l.getWidth(), this.l.getHeight());
        this.changeActionAllPerformed(null);
    }

    @Override
    public int getShape() {
        return 1;
    }

    public void setVisible(boolean visible) {
        this.l.setVisible(visible);
    }

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
    }
}

