/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.util.HashMap;
import java.util.List;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ActionID;

public class ListActionViewer<T>
extends FieldViewer<T>
implements SwingItem {
    T panel;
    List<BeanViewerAction<ViewerContext>> list;
    HashMap<BeanViewerAction<ViewerContext>, T> map = new HashMap();
    private boolean onlyOnePressed;

    public ListActionViewer(UIFactory<T> factory) {
        super(factory);
        this.panel = factory.getPanel();
    }

    public void setSelected() {
        for (BeanViewerAction<ViewerContext> bva : this.list) {
            if (!bva.isToggle()) continue;
            bva.setSelected(this.getFactory().getToggleValue(this.map.get(bva)));
        }
    }

    private void initUI() {
        this.map.clear();
        this.getFactory().clearContainer(this.panel);
        Object bg = null;
        if (this.onlyOnePressed) {
            bg = this.getFactory().getButtonGroup();
        }
        for (BeanViewerAction<ViewerContext> bva : this.list) {
            if (bva.isToggle()) {
                Object b = this.getFactory().getToggleButton(bva, this);
                if (this.onlyOnePressed) {
                    this.getFactory().addButtonToGroup(bg, b);
                }
                this.getFactory().putObjectToContainer(b, this.panel, null);
                this.map.put(bva, b);
            } else {
                Object component = this.getFactory().getAction(bva, null);
                this.getFactory().putObjectToContainer(component, this.panel, null);
                this.map.put(bva, component);
            }
            bva.setContext(this.getViewerContext());
        }
        this.getFactory().revalidate(this.panel);
    }

    @Override
    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
        if (this.list != null) {
            for (BeanViewerAction<ViewerContext> bva : this.list) {
                bva.setContext(viewerContext);
            }
        }
    }

    @Override
    public void setPropertyUI(String key, String value) {
        if ("onlyonepressed".equals(key.toLowerCase())) {
            this.onlyOnePressed = Boolean.parseBoolean(value);
        } else {
            super.setPropertyUI(key, value);
        }
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public Object getValue() {
        return this.list;
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    public void setVisibleToAction(BeanViewerAction<ViewerContext> bva, boolean visible) {
        this.getFactory().setVisibleObject(this.map.get(bva), visible);
    }

    public void setEnableToAction(BeanViewerAction<ViewerContext> bva, boolean enable) {
        this.getFactory().setComponentEditable(this.map.get(bva), enable);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        for (T b : this.map.values()) {
            this.getFactory().setComponentEditable(b, editable);
        }
    }

    @Override
    public void update(Object value, ActionID id) {
    }

    @Override
    public void setValue(Object object) {
        this.list = (List)object;
        this.initUI();
    }
}

