/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import ru.infor.beanviewer.core.ManagerBeanPanel;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.AbstractContext;

public abstract class ObjectManager<T>
implements Comparable<ObjectManager<T>> {
    private static final long serialVersionUID = -4910969197828286403L;
    Logger logger = Logger.getLogger(ObjectManager.class.getName());
    private boolean editable = true;
    private Integer order = 0;
    Class<?> cls;
    private UIFactory<T> factory;
    private Method creator;
    private Method remover;
    private Method editor;
    private List<BeanViewerAction<AbstractContext<?>>> actions = new ArrayList();
    private List<ManagerBeanPanel<T>> listmbp = new ArrayList<ManagerBeanPanel<T>>();

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public abstract T getComponent();

    public abstract void setTitle(String var1);

    public boolean isEditable() {
        return this.editable;
    }

    public abstract void add(T var1);

    public ObjectManager(UIFactory<T> factory) {
        this.factory = factory;
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public void setCls(Class<?> cls) {
        this.cls = cls;
    }

    public void setCreator(Method creator) {
        this.creator = creator;
    }

    public Method getCreator() {
        return this.creator;
    }

    public void setRemover(Method remover) {
        this.remover = remover;
    }

    public void setEditor(Method m) {
        this.editor = m;
    }

    public T addAction(BeanViewerAction bva) {
        T t = this.factory.getAction(bva, null);
        this.add(t);
        this.actions.add(bva);
        return t;
    }

    public void addPanel(ManagerBeanPanel<T> mbp) {
        this.add(mbp.getPanel());
        this.listmbp.add(mbp);
    }

    public void notifyUpdate() {
        for (BeanViewerAction<AbstractContext<?>> beanViewerAction : this.actions) {
            beanViewerAction.getContext().notifyObjectChangeListeners();
        }
        for (ManagerBeanPanel managerBeanPanel : this.listmbp) {
            managerBeanPanel.updateUI();
        }
    }

    @Override
    public int compareTo(ObjectManager<T> o) {
        return this.order.compareTo(o.getOrder());
    }
}

