/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import ru.infor.beanviewer.core.AbstractNode;
import ru.infor.beanviewer.core.BaseNode;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.TreeViewer;

public class RawObjectViewer
extends TreeViewer {
    private Object object;

    public RawObjectViewer(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    public Object getValue() {
        return this.object;
    }

    @Override
    public void setValue(Object value) {
        this.object = value;
        super.setValue(new ObjectItemNode(this.object, "\u041e\u0431\u044a\u0435\u043a\u0442"));
    }

    private class ObjectItemNode
    extends AbstractNode {
        private static final long serialVersionUID = -4371314821330105709L;
        private Object item;
        private List<Getter> getters = new ArrayList<Getter>();
        private ObjectItemNode[] children;
        private ObjectItemNode parent;
        private String name;

        public ObjectItemNode(final Object object, String name) {
            this.name = name;
            this.item = object;
            if (object != null) {
                Class<?> clo = object.getClass();
                if (Iterable.class.isAssignableFrom(clo)) {
                    Iterable co = (Iterable)object;
                    int i = 0;
                    for (final Object t : co) {
                        final int j = i++;
                        this.getters.add(new Getter(){

                            @Override
                            public Object get() {
                                return t;
                            }

                            @Override
                            public String getName() {
                                return "[" + j + "]";
                            }
                        });
                    }
                }
                if (clo.isArray()) {
                    int i = 0;
                    while (i < Array.getLength(object)) {
                        final int j = i++;
                        this.getters.add(new Getter(){

                            @Override
                            public Object get() {
                                return Array.get(object, j);
                            }

                            @Override
                            public String getName() {
                                return "[" + j + "]";
                            }
                        });
                    }
                }
                for (final Field field : clo.getFields()) {
                    this.getters.add(new Getter(){

                        @Override
                        public Object get() {
                            Object ret = null;
                            try {
                                ret = field.get(object);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return ret;
                        }

                        @Override
                        public String getName() {
                            return "\u041f\u043e\u043b\u0435 " + field.getName();
                        }
                    });
                }
                for (AccessibleObject accessibleObject : clo.getMethods()) {
                    if (((Method)accessibleObject).getParameterTypes().length != 0 || ((Method)accessibleObject).getReturnType() == null || !((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is")) continue;
                    this.getters.add(new Getter((Method)accessibleObject, object){
                        final /* synthetic */ Method val$method;
                        final /* synthetic */ Object val$object;
                        {
                            this.val$method = method;
                            this.val$object = object;
                        }

                        @Override
                        public Object get() {
                            Object ret = null;
                            try {
                                ret = this.val$method.invoke(this.val$object, new Object[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return ret;
                        }

                        @Override
                        public String getName() {
                            return "\u041c\u0435\u0442\u043e\u0434 " + this.val$method.getName() + "()";
                        }
                    });
                }
            }
            this.children = new ObjectItemNode[this.getters.size()];
        }

        @Override
        public ObjectItemNode getChildAt(int childIndex) {
            if (this.children[childIndex] == null) {
                this.children[childIndex] = new ObjectItemNode(this.getters.get(childIndex).get(), this.getters.get(childIndex).getName());
                this.children[childIndex].setParent(this);
            }
            return this.children[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.getters.size();
        }

        @Override
        public ObjectItemNode getParent() {
            return this.parent;
        }

        public void setParent(ObjectItemNode parent) {
            this.parent = parent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName() + " " + (this.item == null ? "null" : this.item.getClass().getName() + ": " + this.item);
        }

        public ObjectItemNode addChild(ObjectItemNode child) {
            return child;
        }

        @Override
        public void removeAllChildren() {
        }

        public void removeChild(ObjectItemNode child) {
        }

        @Override
        public boolean isLeaf() {
            return RawObjectViewer.this.object == null || RawObjectViewer.this.object.getClass().isPrimitive() || RawObjectViewer.this.object.getClass().equals(String.class);
        }

        @Override
        public BaseNode addChild(BaseNode child) {
            return child;
        }

        @Override
        public void moveChild(BaseNode child) {
        }

        @Override
        public void removeChild(BaseNode child) {
        }

        @Override
        public int compareTo(BaseNode o) {
            return super.compareTo((ObjectItemNode)o);
        }
    }

    private static interface Getter {
        public Object get();

        public String getName();
    }
}

