/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.AbstractNode;
import ru.infor.beanviewer.core.BaseNode;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.processor.UIDefinitionProcessor;
import ru.infor.beanviewer.core.processor.raw.RawProcessor;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.TextViewer;
import ru.infor.beanviewer.viewer.TreeViewer;

public class ScriptViewer
extends TextViewer {
    ScriptEngine se;
    JSplitPane splitPanel = new JSplitPane();
    AttributeSet err;
    AttributeSet reg;

    public ScriptViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.splitPanel.setLeftComponent(this.panel);
        this.err = StyleContext.getDefaultStyleContext().addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Background, new Color(255, 150, 150));
        this.reg = StyleContext.getDefaultStyleContext().addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Background, new Color(255, 255, 255));
    }

    @Override
    public Object getValue() {
        return new Object[]{super.getValue(), this.se};
    }

    @Override
    public void setValue(Object object) {
        super.setValue(((Object[])object)[0]);
        this.se = (ScriptEngine)((Object[])object)[1];
        final EnvironmentNode root = new EnvironmentNode();
        root.setName("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
        root.setValue("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
        final Objects obj = new Objects(root);
        List<Integer> scopes = this.se.getContext().getScopes();
        for (int i : scopes) {
            Bindings bindings = this.se.getBindings(i);
            for (String t : bindings.keySet()) {
                EnvironmentNode en = new EnvironmentNode();
                en.setName(t);
                en.setValue(bindings.get(t));
                root.addChild(en);
            }
        }
        final BeanPanel<JComponent> bp = SwingFactory.getInstance().createPanel(null, Objects.class, obj, null, "");
        BeanViewerAction test = new BeanViewerAction(){

            @Override
            public void actionPerformed(Object message) {
                try {
                    int length = ScriptViewer.this.tp.getText().length();
                    ScriptViewer.this.tp.getStyledDocument().setCharacterAttributes(0, length, ScriptViewer.this.reg, false);
                    ScriptViewer.this.se.eval(ScriptViewer.this.tp.getText());
                    List<Integer> scopes = ScriptViewer.this.se.getContext().getScopes();
                    root.removeAllChildren();
                    for (int i : scopes) {
                        Bindings bindings = ScriptViewer.this.se.getBindings(i);
                        for (String t : bindings.keySet()) {
                            if (t.equals("print") || t.equals("println") || t.equals("context")) continue;
                            EnvironmentNode en = new EnvironmentNode();
                            en.setName(t);
                            en.setValue(bindings.get(t));
                            root.addChild(en);
                        }
                    }
                    obj.setRootElement(root);
                    bp.update(obj);
                }
                catch (ScriptException e1) {
                    int chars;
                    String s = ScriptViewer.this.tp.getText();
                    int lines = 0;
                    for (chars = 0; lines < e1.getLineNumber() - 1 && chars < s.length(); ++chars) {
                        if (s.charAt(chars) != '\n') continue;
                        ++lines;
                    }
                    try {
                        int end = Utilities.getRowEnd(ScriptViewer.this.tp, chars);
                        ScriptViewer.this.tp.getStyledDocument().setCharacterAttributes(chars, end - chars + 1, ScriptViewer.this.err, false);
                    }
                    catch (BadLocationException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        };
        test.setName("\u0422\u0435\u0441\u0442");
        bp.addActionToManagementPanel(test);
        BeanViewerAction arrow = new BeanViewerAction(){

            @Override
            public void actionPerformed(Object message) {
                SwingFactory.JUITextPane tp = ScriptViewer.this.tp;
                String sig = ((EnvironmentNode)root.getSelected()).getSignature();
                try {
                    tp.getDocument().insertString(tp.getCaretPosition(), sig, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        };
        arrow.setName("\u0422\u0435\u0441\u0442");
        arrow.setIcon("/data/icons/arrow_left.png");
        bp.addActionToManagementPanel(arrow);
        this.splitPanel.setRightComponent(bp.getPanel());
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.splitPanel;
    }

    @ListView(views={@View(title="\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b")})
    public class EnvironmentNode
    extends AbstractNode {
        private static final long serialVersionUID = 3310000918725574872L;
        String name;
        Object value;
        List<FieldPresentation<JComponent>> fpl;
        Method getter = null;
        Object selected;

        @Override
        public int compareTo(BaseNode oo) {
            EnvironmentNode o = (EnvironmentNode)oo;
            return (this.isLeaf() ? "\u044f\u044f\u044f\u044f\u044f\u044f\u044f\u044f\u044f\u044f" : "" + this.getName()).compareTo(o.isLeaf() ? "\u044f\u044f\u044f\u044f\u044f\u044f\u044f\u044f\u044f\u044f" : "" + o.getName());
        }

        public Object getSelected() {
            return this.selected;
        }

        public void setSelected(Object selected) {
            this.selected = selected;
        }

        public String getSignature() {
            if (this.getParent().getParent() == null) {
                return this.getName();
            }
            String signature = "";
            if (this.getter != null) {
                signature = signature + "." + this.getter.getName() + "(";
                boolean first = true;
                for (Class<?> cls : this.getter.getParameterTypes()) {
                    if (!first) {
                        signature = signature + ", ";
                    } else {
                        first = false;
                    }
                    signature = signature + cls.getName();
                }
                signature = signature + ")";
            }
            return ((EnvironmentNode)this.getParent()).getSignature() + signature;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String title) {
            this.name = title;
        }

        public String toString() {
            StringBuilder val = new StringBuilder(this.getName());
            if (this.isLeaf()) {
                val.append('=');
                char q = '\"';
                if (this.getValue().getClass().equals(String.class)) {
                    val.append(q).append(this.getValue()).append(q);
                } else {
                    val.append(this.getValue());
                }
            }
            return val.toString();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
            List<UIDefinitionProcessor> udpl = UIDefinitionProcessor.getProcessors();
            for (int index = 0; index < udpl.size(); ++index) {
                if (!(udpl.get(index) instanceof RawProcessor)) continue;
                udpl.remove(index);
                break;
            }
            this.fpl = FieldPresentation.parse(value.getClass(), null, ScriptViewer.this.getFactory(), udpl, "", ScriptViewer.this.getViewerContext().getPresentator().getFieldProperties().get("keyView"));
        }

        @Override
        public boolean isLeaf() {
            if (this.fpl == null) {
                return this.getChildCount() == 0;
            }
            return this.fpl.size() == 0;
        }

        @Override
        public int getChildCount() {
            if (super.getChildCount() == 0 && this.fpl != null) {
                for (FieldPresentation<JComponent> fp : this.fpl) {
                    EnvironmentNode en = new EnvironmentNode();
                    en.setName(fp.getLabel());
                    try {
                        Object val = fp.getGetter().invoke(this.getValue(), new Object[0]);
                        if (val == null) continue;
                        en.setValue(val);
                        en.setGetter(fp.getGetter());
                        this.addChild(en);
                    }
                    catch (Exception exception) {}
                }
            }
            return super.getChildCount();
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter) {
            this.getter = getter;
        }
    }

    @ListView(views={@View(title="\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b")})
    public class Objects {
        EnvironmentNode root;

        public Objects(EnvironmentNode root) {
            this.setRootElement(root);
        }

        @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a", viewer={TreeViewer.class})})
        public EnvironmentNode getRoot() {
            return this.root;
        }

        public void setRootElement(EnvironmentNode root) {
            this.root = root;
        }
    }
}

