/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class TextViewer
extends FieldViewer<JComponent>
implements SwingItem {
    UndoManager undoManager = new UndoManager();
    SwingFactory.JUITextPane tp = new SwingFactory.JUITextPane();
    JPanel panel = new JPanel(new BorderLayout());
    JToolBar tb = new JToolBar();

    @Override
    public void setPropertyUI(String key, String value) {
        if (key.toLowerCase().trim().equals("toolbar")) {
            if (value.toLowerCase().trim().equals("false")) {
                this.tb.setVisible(false);
            }
        } else {
            super.setPropertyField(key, value);
        }
    }

    @Override
    public Class getTableCellViewerClass() {
        return DefaultTableCellViewer.class;
    }

    public TextViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.panel.add((Component)new JScrollPane(this.tp), "Center");
        UndoAction undo = new UndoAction();
        this.tb.add(undo);
        RedoAction redo = new RedoAction();
        this.tb.add(redo);
        this.panel.add((Component)this.tb, "North");
        this.tp.setEditable(false);
        this.tp.setPreferredSize(new Dimension(400, 500));
        this.tp.getDocument().addUndoableEditListener(this.undoManager);
        this.tp.getInputMap().put(KeyStroke.getKeyStroke(90, 2), "undo");
        this.tp.getActionMap().put("undo", undo);
        this.tp.getInputMap().put(KeyStroke.getKeyStroke(89, 2), "redo");
        this.tp.getActionMap().put("redo", redo);
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public Object getValue() {
        return this.tp.getText();
    }

    public void insertTextFromCurcor(String text) {
        int pos = this.tp.getCaretPosition();
        try {
            this.tp.getDocument().insertString(pos, text, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.tp.grabFocus();
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.tp.setEditable(editable);
        this.tb.setEnabled(editable);
    }

    @Override
    public void setValue(Object object) {
        this.tp.setText((String)object);
        this.undoManager.discardAllEdits();
    }

    @Override
    public int getShape() {
        return 1;
    }

    @Override
    public void setFocus() {
        this.getFactory().setFocusOnComponent(this.tp);
    }

    @Override
    public void setChangeValueActionOnEnter(BeanViewerAction<ViewerContext> changeAction) {
    }

    @Override
    public void setChangeValueAction(final BeanViewerAction changeAction) {
        this.tp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                changeAction.actionPerformed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                changeAction.actionPerformed(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                changeAction.actionPerformed(e);
            }
        });
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2608988213429348517L;

        public UndoAction() {
            super(null, new ImageIcon(TextViewer.class.getResource("/data/icons/arrow_undo.png")));
            super.putValue("ShortDescription", "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TextViewer.this.undoManager.canUndo()) {
                TextViewer.this.undoManager.undo();
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -8539128326121500400L;

        public RedoAction() {
            super(null, new ImageIcon(TextViewer.class.getResource("/data/icons/arrow_redo.png")));
            super.putValue("ShortDescription", "\u0412\u0435\u0440\u043d\u0443\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TextViewer.this.undoManager.canRedo()) {
                TextViewer.this.undoManager.redo();
            }
        }
    }

    public static class JUITextField
    extends JTextField {
        private static final long serialVersionUID = 7507515507088860518L;
        List<BeanViewerAction<ViewerContext>> list = new ArrayList<BeanViewerAction<ViewerContext>>();

        public void addAction(BeanViewerAction<ViewerContext> bva) {
            this.list.add(bva);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            for (BeanViewerAction<ViewerContext> bva : this.list) {
                bva.actionPerformed(null);
            }
        }
    }
}

