/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer;

import java.util.ArrayList;
import java.util.List;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.tree.Tree;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.ManagerListener;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ActionID;

public class TreeViewer<T>
extends BigContentViewer<T>
implements ManagerListener,
SwingItem {
    protected Tree<T> tree = this.getFactory().getTree();

    @Override
    public void updateValue(Object value, ActionID id) {
        if (id == null) {
            this.setBValue(value);
        } else if (id.equals((Object)ActionID.ADD)) {
            ArrayList<Object> a = new ArrayList<Object>(1);
            a.add(value);
            this.add(a);
        } else if (id.equals((Object)ActionID.EDIT)) {
            this.change(value);
        }
        this.changeActionAllPerformed(null);
    }

    public void setValueAndSelect(Object value) {
        this.tree.setValueAndSelect(value);
    }

    public TreeViewer(UIFactory<T> factory) {
        super(factory);
    }

    @Override
    public Object getBValue() {
        return this.tree.getRootValue();
    }

    @Override
    public List<Object> getSelectedItems() {
        return this.tree.getSelection();
    }

    @Override
    public void setBValue(Object value) {
        this.tree.updateRoot(value);
        this.changeActionAllPerformed(null);
    }

    @Override
    public void add(List<?> obj) {
        this.tree.addToSelection(obj);
    }

    public void setSelection(Object value) {
        this.tree.setSelection(value);
    }

    public void change(Object obj) {
        this.tree.updateUIForSelectedObject();
    }

    @Override
    public Object getCurrent() {
        return this.tree.getSelected();
    }

    @Override
    public List<Object> remove() {
        return this.tree.removeSelected();
    }

    @Override
    public Class getTableCellViewerClass() {
        return DefaultTableCellViewer.class;
    }

    @Override
    public T createContentComponent() {
        return this.tree.getTreeComponent();
    }

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
        this.tree.setChangeValueAction(changeAction);
    }

    @Override
    public int[] getSelectedRows() {
        return null;
    }

    @Override
    public void addActionOnSelectionListener(BeanViewerAction<AbstractContext<?>> bva) {
        this.tree.addActionOnSelectionListener(bva);
    }

    @Override
    public void addHotKey(BeanViewerAction<ViewerContext> bva) {
        this.getFactory().addHotKey(this.tree.getTreeComponent(), bva);
    }
}

