/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.directory;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ru.infor.beanviewer.viewer.directory.CBUI;
import ru.infor.beanviewer.viewer.directory.Finder;
import ru.infor.beanviewer.viewer.directory.ListTuner;

public class AutoSearchComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
Finder {
    private static final long serialVersionUID = -2830993831520353328L;
    private JComboBox cb;
    private int longest = 0;
    private List<?> itemsList;
    private Object selected;
    private final ListTuner<JComponent> tuner;
    private boolean isAutomatic = false;

    public AutoSearchComboBoxModel(ListTuner<JComponent> tuner, JComboBox cb) {
        this.cb = cb;
        this.tuner = tuner;
    }

    @Override
    public Object find(String match) {
        if (this.isAutomatic) {
            return null;
        }
        this.itemsList = this.tuner.getTunedValues(match);
        if (this.itemsList != null) {
            this.tuner.updateValue();
        }
        this.longest = 0;
        this.setSelectedItem(this.itemsList == null || this.itemsList.size() == 0 || match.equals("") ? null : this.itemsList.get(0));
        this.fireContentsChanged(this, 0, this.itemsList == null ? 0 : this.itemsList.size());
        if (this.itemsList == null || this.itemsList.size() == 0 || match.equals("")) {
            return null;
        }
        return this.itemsList.get(0);
    }

    @Override
    public Object getElementAt(int index) {
        if (this.itemsList == null) {
            return null;
        }
        Object ret = this.itemsList.get(index);
        if (this.longest < ret.toString().length()) {
            this.longest = ret.toString().length();
            ((CBUI)this.cb.getUI()).getPP().getList().setPrototypeCellValue(ret);
        }
        return ret;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public int getSize() {
        return this.itemsList == null ? 0 : this.itemsList.size();
    }

    @Override
    public void setSelectedItem(Object item) {
        this.selected = item;
    }

    @Override
    public String objectToString(Object o) {
        return this.tuner.objectToString(o);
    }

    public int getSelectedIndex() {
        return this.tuner.getIndex(this.getSelectedItem());
    }

    @Override
    public void setAutomaticUpdate(boolean isAutomatic) {
        this.isAutomatic = isAutomatic;
    }
}

