/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.directory;

import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import ru.infor.beanviewer.viewer.directory.Finder;

public class AutoSearchDocumentFilter
extends DocumentFilter {
    private Finder finder;
    private Object found;
    private SimpleAttributeSet markedSet = new SimpleAttributeSet();
    private SimpleAttributeSet unmarkedSet = new SimpleAttributeSet();
    private int startIndex = 0;
    private int stopIndex = 0;
    private JTextPane tf;
    private boolean update = false;

    public AutoSearchDocumentFilter(Finder finder, JTextPane tf) {
        this.tf = tf;
        this.finder = finder;
        StyleConstants.setBold(this.markedSet, true);
        StyleConstants.setBold(this.unmarkedSet, false);
    }

    public Object getObject() {
        return this.found;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        for (int i = 0; i < string.length(); ++i) {
            if ((byte)string.charAt(i) != 10) continue;
            return;
        }
        this.update(fb, offset, 0, string, 1);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        this.update(fb, offset, length, "", 0);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        for (int i = 0; i < text.length(); ++i) {
            if ((byte)text.charAt(i) != 10) continue;
            return;
        }
        this.update(fb, offset, length, text, 1);
    }

    private void update(DocumentFilter.FilterBypass fb, int offset, int length, String text, int position) throws BadLocationException {
        if (!this.update) {
            this.update = true;
            if (this.startIndex > offset) {
                this.startIndex = offset;
            } else if (this.stopIndex < offset) {
                this.stopIndex = offset;
            }
            int carret = offset - this.startIndex;
            String txt = this.tf.getText().substring(this.startIndex, this.stopIndex);
            String head = txt.substring(0, offset - this.startIndex);
            int tail_index = offset - this.startIndex + length;
            String tail = tail_index > txt.length() ? "" : txt.substring(offset - this.startIndex + length);
            txt = head + text + tail;
            if (!txt.equals("") && (this.found = this.finder.find(txt)) != null) {
                int f_index = this.finder.objectToString(this.found).toLowerCase().indexOf(txt.toLowerCase());
                if (f_index >= 0) {
                    head = this.finder.objectToString(this.found).substring(0, f_index);
                    tail = this.finder.objectToString(this.found).substring(f_index + txt.length());
                    this.startIndex = head.length();
                    this.stopIndex = this.startIndex + txt.length();
                    fb.remove(0, this.tf.getText().length());
                    fb.insertString(0, head, this.unmarkedSet);
                    fb.insertString(head.length(), txt, this.markedSet);
                    fb.insertString(head.length() + txt.length(), tail, this.unmarkedSet);
                } else {
                    this.startIndex = 0;
                    this.stopIndex = txt.length();
                    if (txt.equals("")) {
                        this.found = this.finder.find(txt);
                    }
                    fb.replace(0, this.tf.getText().length(), txt, this.markedSet);
                }
            } else {
                this.startIndex = 0;
                this.stopIndex = txt.length();
                this.found = txt.equals("") ? this.finder.find(txt) : null;
                if (this.tf.getText().length() == 0 && txt.equals("")) {
                    fb.insertString(0, "", this.markedSet);
                } else {
                    fb.replace(0, this.tf.getText().length(), txt, this.markedSet);
                }
            }
            this.tf.setCaretPosition(carret + this.startIndex + position);
            this.update = false;
        }
    }
}

