/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.directory;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import ru.infor.beanviewer.swing.SwingFactory;
import ru.infor.beanviewer.viewer.directory.AutoSearchComboBoxEditor;
import ru.infor.beanviewer.viewer.directory.AutoSearchDocumentFilter;
import ru.infor.beanviewer.viewer.directory.Finder;
import ru.infor.beanviewer.viewer.directory.WrapEditorKit;

public class AutoSearchField
extends SwingFactory.JUITextPane {
    private static final long serialVersionUID = -5961901730052706525L;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private AutoSearchDocumentFilter filter;
    private Finder finder;
    private AutoSearchComboBoxEditor editor;
    private boolean transferOnenter = false;

    public boolean isTransferOnenter() {
        return this.transferOnenter;
    }

    public void setTransferOnenter(boolean transferOnenter) {
        this.transferOnenter = transferOnenter;
    }

    public AutoSearchComboBoxEditor getEditor() {
        return this.editor;
    }

    public AutoSearchField(Finder finder, Component opposite, AutoSearchComboBoxEditor editor) {
        this.finder = finder;
        this.editor = editor;
        this.setEditorKit(new WrapEditorKit());
        this.filter = new AutoSearchDocumentFilter(finder, this);
        ((AbstractDocument)this.getDocument()).setDocumentFilter(this.filter);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    if (AutoSearchField.this.isTransferOnenter()) {
                        AutoSearchField.this.getParent().transferFocus();
                    } else {
                        AutoSearchField.this.notifyAllListeners(e.getID());
                    }
                }
            }
        });
        this.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(9, 0), new AbstractAction(){
            private static final long serialVersionUID = 7715860803712078041L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoSearchField.this.getParent().transferFocus();
            }
        });
    }

    public void notifyAllListeners(int id) {
        ActionEvent ae = new ActionEvent(this, id, this.getText());
        for (ActionListener al : this.listeners) {
            al.actionPerformed(ae);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(l);
    }

    public Object getObject() {
        return this.getText() == null || this.getText().equals("") ? null : this.filter.getObject();
    }

    public void setObject(Object object) {
        this.finder.setAutomaticUpdate(true);
        this.setText(this.finder.objectToString(object));
        this.finder.setAutomaticUpdate(false);
    }
}

