/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.dragndrop;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.infor.beanviewer.core.BaseNode;
import ru.infor.beanviewer.viewer.dragndrop.DNDTree;
import ru.infor.beanviewer.viewer.dragndrop.TransferableNode;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DNDTree tree;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private static BaseNode draggedNode;
    protected BaseNode draggedNodeOldParent;
    protected BaseNode draggedNodeNewParent = null;
    private static BufferedImage image;
    private Rectangle rect2D = new Rectangle();
    private boolean drawImage;

    protected AbstractTreeTransferHandler(DNDTree tree, int action, boolean drawIcon) {
        this.tree = tree;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
        this.dropTarget = new DropTarget(tree, action, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2) {
            if (this.draggedNodeOldParent != null) {
                ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeOldParent);
            }
            if (this.draggedNodeNewParent != null) {
                ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeNewParent);
            }
        }
        if (dsde.getDropSuccess() && dsde.getDropAction() == 1 && this.draggedNodeNewParent != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeNewParent);
        }
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public final void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            draggedNode = (BaseNode)path.getLastPathComponent();
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, draggedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
            }
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new TransferableNode(draggedNode), this);
        }
    }

    @Override
    public final void dragEnter(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dragExit(DropTargetEvent dte) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    @Override
    public final void dragOver(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.tree.autoscroll(pt);
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void drop(DropTargetDropEvent dtde) {
        try {
            if (this.drawImage) {
                this.clearImage();
            }
            int action = dtde.getDropAction();
            Transferable transferable = dtde.getTransferable();
            Point pt = dtde.getLocation();
            if (transferable.isDataFlavorSupported(TransferableNode.NODE_FLAVOR) && this.canPerformAction(this.tree, draggedNode, action, pt)) {
                BaseNode newParentNode;
                TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
                BaseNode node = (BaseNode)transferable.getTransferData(TransferableNode.NODE_FLAVOR);
                if (this.executeDrop(this.tree, node, newParentNode = (BaseNode)pathTarget.getLastPathComponent(), action)) {
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    return;
                }
            }
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
    }

    private final void paintImage(Point pt) {
        this.tree.paintImmediately(this.rect2D.getBounds());
        this.rect2D.setRect((int)pt.getX(), (int)pt.getY(), image.getWidth(), image.getHeight());
        this.tree.getGraphics().drawImage(image, (int)pt.getX(), (int)pt.getY(), this.tree);
    }

    private final void clearImage() {
        this.tree.paintImmediately(this.rect2D.getBounds());
    }

    public abstract boolean canPerformAction(DNDTree var1, BaseNode var2, int var3, Point var4);

    public abstract boolean executeDrop(DNDTree var1, BaseNode var2, BaseNode var3, int var4);

    static {
        image = null;
    }
}

