/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import ru.infor.beanviewer.core.table.ObjectSortKey;
import ru.infor.beanviewer.viewer.list.AsynListProvider;
import ru.infor.beanviewer.viewer.list.AsyncListIndexes;
import ru.infor.beanviewer.viewer.list.DataChangedListener;
import ru.infor.beanviewer.viewer.list.DataChangedListenerFill;

public class AsyncList<T>
extends AbstractList<T> {
    private AsynListProvider<T> alp;
    private boolean filling = false;
    private boolean fullList = false;
    protected AsyncListIndexes<T> indxs = new AsyncListIndexes();
    protected AbstractList<DataChangedListener> listeners = new ArrayList<DataChangedListener>();
    protected AbstractList<DataChangedListenerFill> listenersfill = new ArrayList<DataChangedListenerFill>();
    private List<Integer> pageSize = new ArrayList<Integer>();
    protected int size;
    private boolean totalFill = false;

    protected synchronized boolean isFilling() {
        return this.filling;
    }

    protected synchronized void setFilling(boolean filling) {
        this.filling = filling;
    }

    public AsyncList() {
        this.setPageSize(25);
    }

    public AsyncList(AsynListProvider<T> alp, int pageSize) {
        this.setProvider(alp);
        alp.setAsyncList(this);
        this.setPageSize(pageSize);
    }

    public AsyncList(final Object list) {
        if (list instanceof List) {
            final List ilist = (List)list;
            this.alp = new AsynListProvider(){

                public boolean add(Object obj) {
                    return ilist.add(obj);
                }

                @Override
                public int getCount() {
                    return ilist.size();
                }

                public List getValues(int begin, int count) {
                    return ilist.subList(begin, begin + count);
                }

                @Override
                public boolean isCountActual() {
                    return true;
                }

                public Object set(int index, Object element) {
                    return ilist.set(index, element);
                }

                public void setAsyncList(AsyncList list) {
                }

                public void setSortKeys(List sortKeys) {
                }
            };
        } else if (list.getClass().isArray()) {
            this.alp = new AsynListProvider(){

                public boolean add(Object obj) {
                    return false;
                }

                @Override
                public int getCount() {
                    return Array.getLength(list);
                }

                public List getValues(int begin, int count) {
                    if (begin < 0) {
                        begin = 0;
                    }
                    if (begin + count > this.getCount()) {
                        count = this.getCount();
                    }
                    ArrayList<Object> ret = new ArrayList<Object>();
                    for (int i = 0; i < count; ++i) {
                        ret.add(Array.get(list, i + begin));
                    }
                    return ret;
                }

                @Override
                public boolean isCountActual() {
                    return true;
                }

                public Object set(int index, Object element) {
                    Array.set(list, index, element);
                    return element;
                }

                public void setAsyncList(AsyncList list2) {
                }

                public void setSortKeys(List sortKeys) {
                }
            };
        }
        this.setPageSize(25);
        this.size = -1;
    }

    @Override
    public boolean add(T e) {
        boolean ret = this.alp.add(e);
        if (ret) {
            this.size = this.alp.getCount();
        }
        return ret;
    }

    public void addDataChangedListener(DataChangedListener dcl) {
        if (!this.listeners.contains(dcl)) {
            this.listeners.add(dcl);
        }
    }

    public void addPageSizeToSequence(int pageSize) {
        this.pageSize.add(pageSize);
    }

    private int[] calcIndexes(int index, int pageSize, AsyncListIndexes<T> indx) {
        int endIndex = index;
        for (int i = 0; i < pageSize && endIndex < this.size() && !indx.containsKey(endIndex); ++endIndex, ++i) {
        }
        int begIndex = index;
        for (int i = 0; i < pageSize - (endIndex - index) && begIndex > 0 && !indx.containsKey(begIndex); --begIndex, ++i) {
        }
        if (indx.containsKey(begIndex)) {
            // empty if block
        }
        return new int[]{++begIndex, endIndex};
    }

    public synchronized void compromateAllData() {
        this.indxs.setDead(true);
        this.setFilling(false);
        this.setFullList(false);
        this.indxs = new AsyncListIndexes();
        this.size = -1;
        for (DataChangedListener changedListener : this.listeners) {
            changedListener.dataChanged(null);
        }
    }

    private int[] fillPage(int index, int pageSize, AsyncListIndexes<T> indx) {
        int[] ind = this.calcIndexes(index, pageSize, indx);
        List<T> ret = null;
        if (ind[1] > ind[0]) {
            indx.loadAdd(ind[0], ind[1] - ind[0]);
            ret = this.alp.getValues(ind[0], ind[1] - ind[0]);
            indx.loadRemove(ind[0]);
            if (!indx.isDead() && ret != null) {
                int i = ind[0];
                while (i - ind[0] < ret.size()) {
                    indx.put(i, ret.get(i - ind[0]));
                    ++i;
                }
            }
        }
        return new int[]{ind[0], ret == null ? 0 : ret.size()};
    }

    @Override
    public synchronized T get(int index) {
        return this.get(index, 0, this.indxs);
    }

    public T get(int index, int tail, final AsyncListIndexes<T> indx) {
        if (indx.isDead() || index >= this.size()) {
            return null;
        }
        if (!indx.containsKey(index)) {
            if (!this.isSheduled(index, tail >= 0 ? this.pageSize.get(tail) : 250, indx)) {
                final int[] e1 = this.fillPage(index, tail >= 0 ? this.pageSize.get(tail) : 250, indx);
                if (e1[1] == 0) {
                    this.size = -1;
                }
                if (indx.isDead()) {
                    return null;
                }
                for (int i = e1[0]; i < e1[0] + e1[1]; ++i) {
                    indx.planRemove(i);
                }
                if (tail == 0 && e1[1] != 0) {
                    new Thread(){

                        @Override
                        public void run() {
                            int i;
                            int actual = e1[0] + e1[1];
                            if (!AsyncList.this.totalFill) {
                                for (i = 1; i < AsyncList.this.pageSize.size() && !indx.isDead() && actual < AsyncList.this.size(); actual += ((Integer)AsyncList.this.pageSize.get(i)).intValue(), ++i) {
                                    AsyncList.this.get(actual, i, indx);
                                }
                            }
                            if (AsyncList.this.totalFill && !AsyncList.this.isFilling()) {
                                AsyncList.this.setFilling(true);
                                actual = 0;
                                i = AsyncList.this.pageSize.size() - 1;
                                while (!indx.isDead() && actual < AsyncList.this.size()) {
                                    while (indx.containsKey(actual)) {
                                        ++actual;
                                    }
                                    if (!AsyncList.this.isSheduled(actual, (Integer)AsyncList.this.pageSize.get(i), indx)) {
                                        int[] e12 = AsyncList.this.fillPage(actual, (Integer)AsyncList.this.pageSize.get(i), indx);
                                        if (e12[1] == 0) {
                                            AsyncList.this.size = -1;
                                        }
                                        for (int k = e12[0]; k < e12[0] + e12[1]; ++k) {
                                            indx.planRemove(k);
                                        }
                                        actual += e12[1];
                                        continue;
                                    }
                                    actual += ((Integer)AsyncList.this.pageSize.get(i)).intValue();
                                }
                                AsyncList.this.setFilling(false);
                                AsyncList.this.setFullList(indx.size() >= AsyncList.this.size());
                            }
                        }
                    }.start();
                }
                this.setFullList(indx.size() >= this.size());
            } else {
                long b = System.currentTimeMillis();
                if (indx.loadContains(index) && !indx.isDead()) {
                    while (!indx.loadContains(index) && !indx.isDead()) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (System.currentTimeMillis() - b <= 1000000L) continue;
                        break;
                    }
                } else if (!indx.containsKey(index) && !indx.isDead()) {
                    indx.planRemove(index);
                    this.get(index);
                }
            }
        }
        return indx.isDead() ? null : (T)indx.get(index);
    }

    public boolean isFullList() {
        return this.fullList;
    }

    private synchronized boolean isSheduled(int value, int size, AsyncListIndexes<T> indx) {
        if (indx.planContains(value)) {
            return true;
        }
        int[] ind = this.calcIndexes(value, size, indx);
        for (int i = ind[0]; i < ind[1] && i < this.size() && !indx.containsKey(i); ++i) {
            indx.planAdd(i);
        }
        return false;
    }

    @Override
    public synchronized T remove(int index) {
        this.size = -1;
        T ret = this.indxs.remove(index);
        ArrayList<Integer> removed = new ArrayList<Integer>();
        for (int i : this.indxs.keySet()) {
            removed.add(i);
        }
        for (int i : removed) {
            this.indxs.remove(i);
        }
        return ret;
    }

    @Override
    public synchronized boolean remove(Object o) {
        this.size = -1;
        this.indxs.clear();
        return true;
    }

    public void removeDataChangedListener(DataChangedListener dcl) {
        this.listeners.remove(dcl);
    }

    @Override
    public T set(int index, T element) {
        return this.alp.set(index, element);
    }

    public void addDataChangedListenerFill(DataChangedListenerFill dcl) {
        if (!this.listenersfill.contains(dcl)) {
            this.listenersfill.add(dcl);
            dcl.dataChanged(this.fullList);
        }
    }

    public void removeDataChangedListenerFill(DataChangedListenerFill dcl) {
        this.listenersfill.remove(dcl);
    }

    protected void setFullList(boolean b) {
        boolean old = this.fullList;
        this.fullList = b;
        if (old != b) {
            for (DataChangedListenerFill dcl : this.listenersfill) {
                dcl.dataChanged(b);
            }
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize.clear();
        this.addPageSizeToSequence(pageSize);
    }

    public void setProvider(AsynListProvider<T> alp) {
        this.alp = alp;
        this.alp.setAsyncList(this);
        this.size = -1;
    }

    public void setSortKeys(List<ObjectSortKey> sortKeys) {
        if (!this.isFullList()) {
            this.alp.setSortKeys(sortKeys);
        }
    }

    public void setSortKeysFL(List<ObjectSortKey> sortKeys) {
        this.alp.setSortKeys(sortKeys);
    }

    public void setTotalFill(boolean tf) {
        this.totalFill = tf;
    }

    @Override
    public int size() {
        if (this.size < 0 || !this.alp.isCountActual()) {
            this.size = this.alp.getCount();
        }
        return this.size;
    }

    public void updateSize() {
        this.size = this.alp.getCount();
    }

    public double getRate() {
        return (double)this.indxs.size() * 1.0 / (double)this.size();
    }
}

