/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import ru.infor.beanviewer.core.FieldPresentation;
import ru.infor.beanviewer.core.Settings;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.UISetter;
import ru.infor.beanviewer.core.processor.ActionViewerDefinition;
import ru.infor.beanviewer.core.processor.ClassDefinition;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.PanelInListContext;

public class BeanPanelInList<T>
extends UISetter<T> {
    protected PanelInListContext pc;
    protected int selectRow = -1;
    private TableWithModel<T> model;
    private Object obj = null;
    private boolean init = false;
    private List<BeanViewerAction<PanelContext>> listBVA = new ArrayList<BeanViewerAction<PanelContext>>();
    private HashMap<Integer, HashMap<FieldPresentation<T>, Object>> oldValues = new HashMap();

    public TableWithModel<T> getModel() {
        return this.model;
    }

    public BeanPanelInList(TableWithModel<T> model, UIFactory<T> factory) {
        this.pc = new PanelInListContext();
        this.factory = factory;
        this.model = model;
    }

    public void setViewerContext(ViewerContext vc) {
        this.pc.setParentContext(vc);
        this.pc.setPanel(this);
        if (vc != null) {
            this.pc.setKeyPage(vc.getKeyPage());
        }
    }

    @Override
    public PanelContext getPanelContext() {
        return this.pc;
    }

    public int getSelectRow() {
        return this.selectRow;
    }

    public void addActToMap(BeanViewerAction<PanelContext> bva, T b) {
        this.actions.put(bva, b);
    }

    public void setSelectRow(int selectRow) {
        this.selectRow = selectRow;
        this.obj = this.model.getObject(selectRow);
        if (!this.model.readOnly) {
            this.storeOldValues();
        }
    }

    @Override
    public void canselCellEditor() {
        this.model.canselCellEditor();
        this.updateUI();
    }

    @Override
    public void stopCellEditor() {
        this.model.stopCellEditor();
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<?> getContentClass() {
        return this.obj != null ? this.obj.getClass() : null;
    }

    @Override
    public boolean canClosed() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    public boolean init(Class<?> cls, String keyContentProperties) {
        List<ActionViewerDefinition> listActions;
        if (this.init) {
            return false;
        }
        this.init = true;
        ClassDefinition cd = FieldPresentation.getClassDefinition(cls, keyContentProperties);
        List<ActionViewerDefinition> list = listActions = cd != null ? cd.getActionsForPanel() : null;
        if (listActions != null && listActions.size() > 0) {
            String kp = "";
            if (this.getPanelContext() != null) {
                kp = this.getPanelContext().getKeyPage();
            }
            HashMap<ActionViewerDefinition, Boolean> m = null;
            if (Settings.getAccessRightForAction() != null) {
                m = Settings.getAccessRightForAction().getAccessViewerActionList(listActions, kp);
            }
            for (ActionViewerDefinition acd : listActions) {
                try {
                    BeanViewerAction<PanelContext> bva = acd.getClazz().newInstance();
                    bva.setContext(this.pc);
                    Boolean e = true;
                    if (m != null && (e = m.get(acd)) == null) {
                        e = false;
                    }
                    bva.setEnable(e);
                    bva.setRightForEnable(e);
                    this.listBVA.add(bva);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).severe("Coudn't create action of " + acd.getClazz().getName() + ":" + e.getMessage());
                }
            }
        }
        return true;
    }

    public List<BeanViewerAction<PanelContext>> getListBVA() {
        return this.listBVA;
    }

    @Override
    public Optional<FieldPresentation<T>> getPresentator(String label) {
        return this.model.getFieldPresentation(label);
    }

    @Override
    public FieldPresentation<T> getPresentatorForName(String name) {
        return this.model.getPresentatorForName(name);
    }

    @Override
    public List<?> getSelectedItems() {
        return null;
    }

    @Override
    public void setField(String s, Object obj1) {
    }

    @Override
    public void setObject(Object obj1) {
    }

    @Override
    public void setTitle(String s) {
    }

    @Override
    public void updateMainObject() {
    }

    @Override
    public void updateUI() {
        this.model.fireTableRowsUpdated(this.getSelectRow());
    }

    @Override
    public void updateUIForPresentatorName(String name) {
        this.model.fireTableRowsUpdated(this.getSelectRow());
    }

    @Override
    public void updateField(FieldPresentation<T> fp) {
    }

    @Override
    public void storeOldValues() {
        HashMap<FieldPresentation<Object>, Object> map = this.oldValues.get(this.selectRow);
        if (map == null) {
            map = new HashMap();
            this.oldValues.put(this.selectRow, map);
        }
        if (this.obj != null && this.model.getColumns() != null) {
            try {
                for (FieldPresentation<T> row : this.model.getColumns()) {
                    Object val = row.getGetter().invoke(this.obj, new Object[0]);
                    map.put(row, val);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void restoreOldValues() {
        HashMap<FieldPresentation<T>, Object> map = this.oldValues.get(this.selectRow);
        if (this.obj != null && map != null) {
            try {
                for (FieldPresentation<T> row : this.model.getColumns()) {
                    Object newValue = map.get(row);
                    if (row == null || row.getSetter() == null || newValue instanceof BeanViewerAction) continue;
                    row.getSetter().invoke(this.obj, newValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

