/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.table.TableWithModel;

public class ListTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -1782884757009749875L;
    FieldViewer<JComponent> fv;
    TableWithModel<JComponent> tm;

    public FieldViewer<JComponent> getFieldViewer() {
        return this.fv;
    }

    public ListTableRenderer(FieldViewer<JComponent> fv, TableWithModel<JComponent> tm) {
        this.fv = fv;
        this.tm = tm;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.fv.setValue(value);
        Component c = this.fv.getComponent(isSelected, hasFocus);
        int r1 = table.getRowSorter().convertRowIndexToModel(row);
        int c1 = table.convertColumnIndexToModel(column);
        Color[] colors = this.tm.getExtendedObject().getColorForegroundBackgroundTable(value, r1, c1);
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            if (colors[1] != null) {
                c.setBackground(colors[1]);
            } else {
                c.setBackground(table.getSelectionBackground());
            }
        } else {
            Color background = table.getBackground();
            if (colors[0] != null) {
                background = colors[0];
            }
            c.setForeground(table.getForeground());
            c.setBackground(background);
        }
        Font f = this.tm.getExtendedObject().getFontTable(value, r1, c1, table.getFont());
        if (f != null) {
            c.setFont(f);
        } else {
            c.setFont(table.getFont());
        }
        return c;
    }
}

