/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.bind.JAXBException;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.core.CollectionTypeTouched;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.PropertyManager;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.swing.viewers.list.TableUIProperties;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.ManagerListener;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ActionID;
import ru.infor.beanviewer.viewer.list.AsyncList;
import ru.infor.beanviewer.viewer.list.BeanPanelInList;
import ru.infor.beanviewer.viewer.list.DataChangedListener;
import ru.infor.beanviewer.viewer.list.ListWithAutoRefresh;
import ru.infor.beanviewer.viewer.list.ListWrapper;
import ru.infor.beanviewer.viewer.list.defaultmenu.TableDataExport;
import ru.infor.beanviewer.viewer.list.defaultmenu.TableDataExportXML;

public class ListViewer<T>
extends BigContentViewer<T>
implements ManagerListener,
CollectionTypeTouched,
SwingItem,
DataChangedListener {
    private boolean dnd = true;
    List<Object> objects;
    protected BeanPanelInList<T> panel;
    Class<? extends Collection<?>> list_class;
    protected TableWithModel<T> tm;
    private TableUIProperties viewerProperty;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    boolean firstInvoke = true;
    String direction;
    String headerSize;
    ExportXLS exportXLS;
    ExportXML exportXML;
    ClearProperties clearProperties;
    SetProperties setProperties;

    @Override
    public void dndEnable(boolean enabled) {
        if (this.tm != null) {
            this.tm.dndEnable(enabled);
        }
        this.dnd = enabled;
    }

    public BeanPanelInList<T> getBeanPanelInList() {
        return this.panel;
    }

    public ListViewer(UIFactory<T> factory) {
        super(factory);
    }

    @Override
    public void add(List<?> objects) {
        if (this.tm != null) {
            this.tm.addMoreRows(objects);
        }
    }

    @Override
    public T createContentComponent() {
        return this.getTM().getTableComponent();
    }

    @Override
    public Object getBValue() {
        if (this.objects == null) {
            return null;
        }
        if (this.list_class != null && Set.class.isAssignableFrom(this.list_class)) {
            HashSet<Object> ret = new HashSet<Object>();
            for (Object object : this.objects) {
                ret.add(object);
            }
            return ret;
        }
        if (this.list_class != null && this.list_class.isArray()) {
            return ((ListWrapper)this.objects).getBaseObject();
        }
        if (this.list_class != null && List.class.isAssignableFrom(this.list_class)) {
            return this.objects;
        }
        return new CopyOnWriteArrayList<Object>(this.objects);
    }

    @Override
    public Object getCurrent() {
        int[] selected = this.tm.getSelectedRows();
        if (selected != null && selected.length > 0) {
            return this.tm.getRows(selected)[0];
        }
        Object[] ret = this.tm.getRows(new int[]{0});
        return ret.length > 0 ? ret[0] : null;
    }

    @Override
    public List<Object> getSelectedItems() {
        return this.tm.getSelectedItems();
    }

    @Override
    public void setFocus() {
        this.getFactory().setFocusOnComponent(this.getTM().getTableComponent());
    }

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return this.getTM().getTableCellViewerClass();
    }

    public TableWithModel<T> getTM() {
        if (this.tm == null) {
            this.tm = this.getFactory().getTable(this);
            this.panel = new BeanPanelInList<T>(this.tm, this.getFactory());
            this.tm.setBp(this.panel);
            this.panel.setViewerContext(this.getViewerContext());
            this.dndEnable(this.dnd);
            this.tm.setDirection(this.direction);
            this.tm.setHeaderSize(this.headerSize);
        }
        return this.tm;
    }

    @Override
    public void setViewerContext(ViewerContext viewerContext) {
        super.setViewerContext(viewerContext);
        if (this.panel != null) {
            this.panel.setViewerContext(viewerContext);
        }
        if (viewerContext != null && this.getTM().getColumns() != null) {
            this.getTM().getColumns().stream().forEach(fp -> fp.getViewer().getViewerContext().setKeyPage(viewerContext.getKeyPage()));
        }
    }

    @Override
    public List<Object> remove() {
        int[] selected = this.tm.getSelectedRows();
        List<Object> removed = this.tm.removeRows(selected);
        this.changeActionAllPerformed(null);
        return removed;
    }

    public void wasChange() {
        this.firstInvoke = true;
    }

    @Override
    public void initDefault() {
        if (this.getContentClass() != null && !this.getContentClass().equals(Object.class)) {
            this.objects = new ArrayList<Object>();
            this.initTable();
        }
    }

    private void initTable() {
        this.getTM();
        if (!this.isReadOnly() && this.firstInvoke && this.panel.init(this.getContentClass(), this.getKeyContentView())) {
            for (BeanViewerAction<PanelContext> bva : this.panel.getListBVA()) {
                this.panel.addActToMap(bva, super.addActionPanelContext(bva, ""));
            }
        }
        this.getTM().updateModel(this.objects, this.getContentClass(), this.getFactory(), this.panel.getPanelContext(), this.viewerProperty, this.firstInvoke, this.getKeyContentView());
        if (this.firstInvoke) {
            for (int i = 0; i < this.tm.getColumnCount(); ++i) {
                FieldViewer<T> cv;
                if (!this.isReadOnly()) {
                    FieldViewer<T> editor = this.tm.getFieldViewer(i);
                    editor.setTableField(true);
                    this.tm.setViewerToEditor(i, editor);
                }
                ViewerContext vc = this.tm.getFieldViewer(i).getViewerContext();
                if (this.tm.getFieldViewer(i).getTableCellViewerClass() == null) {
                    cv = this.tm.getFieldViewer(i);
                    cv.setKey("table" + cv.getClass().getName() + this.getContentClass().getName() + this.tm.getFieldPresentation(this.tm.getColumnName(i)).map(p -> p.getProperty()));
                    this.tm.setViewerToRenderer(i, cv);
                    cv.setViewerContext(vc);
                    continue;
                }
                try {
                    cv = this.tm.getFieldViewer(i).getTableCellViewerClass().getConstructor(UIFactory.class).newInstance(this.getFactory());
                    if (this.tm.getFieldPresentator(i).getFieldProperties() != null) {
                        for (String key : this.tm.getFieldPresentator(i).getFieldProperties().keySet()) {
                            cv.setPropertyField(key, this.tm.getFieldPresentator(i).getFieldProperties().get(key));
                        }
                    }
                    cv.setKey("table" + cv.getClass().getName() + this.getContentClass().getName() + this.tm.getFieldPresentation(this.tm.getColumnName(i)).map(p -> p.getProperty()));
                    this.tm.setViewerToRenderer(i, cv);
                    cv.setViewerContext(vc);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FieldViewer<T> cv2 = this.tm.getFieldViewer(i);
                    cv2.setKey("table" + cv2.getClass().getName() + this.getContentClass().getName() + this.tm.getFieldPresentation(this.tm.getColumnName(i)).map(p -> p.getProperty()));
                    this.tm.setViewerToRenderer(i, cv2);
                    cv2.setViewerContext(vc);
                }
            }
            if (PropertyManager.getSaver() != null) {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<FieldViewer<T>> fpl = new ArrayList<FieldViewer<T>>();
                for (int i = 0; i < this.tm.getColumnCount(); ++i) {
                    FieldViewer<T> fv = this.tm.getViewerToRenderer(i);
                    if (fv.getUIPropertiesClass() == null) continue;
                    keys.add(fv.getKey());
                    fpl.add(fv);
                }
                String[] properties = PropertyManager.getSaver().loadAll(keys.toArray(new String[0]));
                int i = 0;
                for (FieldViewer fieldViewer : fpl) {
                    String p2;
                    if ((p2 = properties[i++]) == null || "".equals(p2)) continue;
                    try {
                        fieldViewer.setUIProperties(PropertyManager.xmlToProperties(fieldViewer.getUIPropertiesClass(), p2));
                    }
                    catch (JAXBException e1) {
                        this.logger.severe("Can't load properties for " + fieldViewer.getKey());
                    }
                }
            }
            this.firstInvoke = false;
        }
    }

    @Override
    public void setBValue(Object value) {
        Class<?> oldContent = this.getContentClass();
        if (value != null) {
            if (value instanceof List) {
                this.objects = (List)value;
                if (value instanceof AsyncList) {
                    ((AsyncList)value).addDataChangedListener(this);
                }
            } else if (value.getClass().isArray()) {
                try {
                    this.objects = new ListWrapper<Object>(value);
                }
                catch (UnsupportedDataTypeException e) {
                    e.printStackTrace();
                }
            } else {
                this.objects = new CopyOnWriteArrayList<Object>((Collection)value);
            }
        } else {
            try {
                this.objects = this.list_class.isArray() ? new ListWrapper<Object>(Array.newInstance(this.getContentClass(), 0)) : new ListWrapper<Object>(new ArrayList());
            }
            catch (UnsupportedDataTypeException e) {
                // empty catch block
            }
        }
        if (!(this.objects instanceof AsyncList) || this.getContentClass() == null || this.getContentClass().equals(Object.class)) {
            if (this.objects.size() > 0 && this.objects.get(0) != null) {
                Class<?> cc = this.objects.get(0).getClass();
                if (this.getContentClass() != null && !this.getContentClass().equals(Object.class)) {
                    if (!this.getContentClass().isAssignableFrom(cc)) {
                        this.setContentClass(cc);
                    }
                } else {
                    this.setContentClass(cc);
                }
            } else {
                try {
                    if (this.getContentClass() == null || this.getContentClass().equals(Object.class)) {
                        this.setContentClass(this.getCreator().invoke(((PanelContext)this.getViewerContext().getParentContext()).getObject(), new Object[0]).getClass());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!oldContent.equals(this.getContentClass())) {
            this.firstInvoke = true;
        }
        this.initTable();
        this.changeActionAllPerformed(null);
        this.tm.fireTableDataChanged();
        this.updateCount();
        if (this.viewerProperty == null) {
            this.setUIProperties(this.getUIProperties());
        }
    }

    @Override
    public void setChangeValueAction(BeanViewerAction beanvieweraction) {
    }

    public void setListClass(Class list_class) {
        this.list_class = list_class;
    }

    @Override
    public void dataChanged(Object message) {
        this.tm.fireTableDataChanged();
        this.updateCount();
    }

    @Override
    public int[] getSelectedRows() {
        return this.tm.getSelectedRows();
    }

    protected void updateCountLabel(String text) {
        Object label;
        if (this.getViewerContext() != null && this.getViewerContext().getParentContext() != null && (label = ((BeanPanel)((PanelContext)this.getViewerContext().getParentContext()).getPanel()).getLayout().getLabelForPresentator(this.getViewerContext().getPresentator())) != null) {
            String s = this.getViewerContext().getPresentator().getLabel();
            if (s != null && !s.trim().equals("")) {
                s = s.concat("/");
            }
            this.getFactory().setTextToComponent(label, s + text);
        }
    }

    private void updateCount() {
        String k = "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 " + this.objects.size();
        this.updateCountLabel(k);
    }

    @Override
    public void updateValue(Object value, ActionID id) {
        if (value == null || this.list_class.isAssignableFrom(value.getClass())) {
            this.setBValue(value);
        }
        if (id != null && id.equals((Object)ActionID.EDIT)) {
            this.panel.updateUI();
        }
        this.getObjectManagers().parallelStream().forEach(om -> om.notifyUpdate());
        this.tm.update(value, id);
        this.changeActionAllPerformed(null);
        this.updateCount();
    }

    @Override
    public void addActionOnSelectionListener(BeanViewerAction bva) {
        this.getTM().addActionOnSelectionListener(bva);
    }

    @Override
    public TableUIProperties getUIProperties() {
        return this.tm.getUIProperties();
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        this.viewerProperty = (TableUIProperties)viewerProperty;
        if (this.tm != null && !this.firstInvoke) {
            this.tm.setUIProperties(viewerProperty);
        }
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return TableUIProperties.class;
    }

    @Override
    public void setPropertyUI(String key, String value) {
        if ("direction".equals(key)) {
            this.direction = value;
        }
        if ("headerSize".equals(key)) {
            this.headerSize = value;
        }
    }

    @Override
    public void addHotKey(BeanViewerAction<ViewerContext> bva) {
        this.getFactory().addHotKey(this.getTM().getTableComponent(), bva);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.objects != null && this.objects instanceof ListWithAutoRefresh) {
            ((ListWithAutoRefresh)((Object)this.objects)).setAutoRefresh(false);
        }
    }

    @Override
    public List<BeanViewerAction<ViewerContext>> getPopupMenu() {
        List<BeanViewerAction<ViewerContext>> l = super.getPopupMenu();
        if (l == null) {
            l = new ArrayList<BeanViewerAction<ViewerContext>>();
        }
        if (this.exportXLS == null) {
            this.exportXLS = new ExportXLS();
            this.exportXLS.setFactory(this.getFactory());
            this.exportXLS.setTableWithModel(this.getTM());
        }
        l.add(this.exportXLS);
        if (this.exportXML == null) {
            this.exportXML = new ExportXML();
            this.exportXML.setFactory(this.getFactory());
            this.exportXML.setTableWithModel(this.getTM());
        }
        l.add(this.exportXML);
        if (this.setProperties == null) {
            this.setProperties = new SetProperties();
            this.setProperties.setListViewer(this);
        }
        l.add(this.setProperties);
        if (this.clearProperties == null) {
            this.clearProperties = new ClearProperties();
            this.clearProperties.setTableWithModel(this.getTM());
        }
        l.add(this.clearProperties);
        return l;
    }

    @Override
    public Object getNewUiProperties() {
        return new TableUIProperties();
    }

    public static class SetProperties
    extends BeanViewerAction<ViewerContext> {
        ListViewer listViewer;

        public ListViewer getListViewer() {
            return this.listViewer;
        }

        public void setListViewer(ListViewer listViewer) {
            this.listViewer = listViewer;
        }

        @Override
        public String getName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430";
        }

        @Override
        public void actionPerformed(Object message) {
            TableUIProperties properties = this.listViewer.getUIProperties();
            if (properties == null) {
                try {
                    properties = this.listViewer.getTM().getDefaultUIProperties();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.listViewer.getFactory().newPage(this.listViewer.getUIPropertiesClass(), this.listViewer.getUIPropertiesClass(), (Object)properties, this.listViewer.getViewerContext(), this.listViewer.getUIPropertiesKeyView(), this.listViewer.getViewerContext().getKeyPage());
        }
    }

    public static class ClearProperties
    extends BeanViewerAction<ViewerContext> {
        TableWithModel<?> tableWithModel;

        public TableWithModel<?> getTableWithModel() {
            return this.tableWithModel;
        }

        public void setTableWithModel(TableWithModel<?> tableWithModel) {
            this.tableWithModel = tableWithModel;
        }

        @Override
        public String getName() {
            return "\u0421\u0431\u0440\u043e\u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430";
        }

        @Override
        public void actionPerformed(Object message) {
            this.tableWithModel.setUIProperties(this.tableWithModel.getDefaultUIProperties());
        }
    }

    public static class ExportXML
    extends BeanViewerAction<ViewerContext> {
        UIFactory<?> factory;
        TableWithModel<?> tableWithModel;

        public TableWithModel<?> getTableWithModel() {
            return this.tableWithModel;
        }

        public void setTableWithModel(TableWithModel<?> tableWithModel) {
            this.tableWithModel = tableWithModel;
        }

        public UIFactory<?> getFactory() {
            return this.factory;
        }

        public void setFactory(UIFactory<?> factory) {
            this.factory = factory;
        }

        @Override
        public String getName() {
            return "\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 XML";
        }

        @Override
        public void actionPerformed(Object message) {
            new TableDataExportXML(this, this.factory, this.tableWithModel);
        }
    }

    public static class ExportXLS
    extends BeanViewerAction<ViewerContext> {
        UIFactory<?> factory;
        TableWithModel<?> tableWithModel;

        public TableWithModel<?> getTableWithModel() {
            return this.tableWithModel;
        }

        public void setTableWithModel(TableWithModel<?> tableWithModel) {
            this.tableWithModel = tableWithModel;
        }

        public UIFactory<?> getFactory() {
            return this.factory;
        }

        public void setFactory(UIFactory<?> factory) {
            this.factory = factory;
        }

        @Override
        public String getName() {
            return "\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 XLS";
        }

        @Override
        public void actionPerformed(Object message) {
            new TableDataExport(this, this.factory, this.tableWithModel);
        }
    }
}

