/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;

public class ListWrapper<T>
implements List<T> {
    List<T> list;
    T[] arr;
    Set<T> set;

    public ListWrapper(Object obj) throws UnsupportedDataTypeException {
        if (obj instanceof List) {
            this.list = (List)obj;
        } else if (obj instanceof Set) {
            this.set = (Set)obj;
        } else if (obj.getClass().isArray()) {
            this.arr = (Object[])obj;
        } else {
            throw new UnsupportedDataTypeException("ListWrapper do not support " + obj.getClass() + " as list.");
        }
    }

    public Object getBaseObject() {
        if (this.list != null) {
            return this.list;
        }
        if (this.arr != null) {
            return this.arr;
        }
        if (this.set != null) {
            return this.set;
        }
        return null;
    }

    @Override
    public boolean add(T e) {
        if (this.list != null) {
            return this.list.add(e);
        }
        if (this.arr != null) {
            this.arr = Arrays.copyOf(this.arr, this.arr.length + 1);
            this.arr[this.arr.length - 1] = e;
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, T element) {
        if (this.list != null) {
            this.list.add(index, element);
        }
        if (this.arr != null) {
            T[] temp = Arrays.copyOf(this.arr, this.arr.length + 1);
            temp[index] = element;
            for (int i = index + 1; i < this.arr.length; ++i) {
                temp[i] = this.arr[i - 1];
            }
            this.arr = temp;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.list != null) {
            return this.list.addAll(c);
        }
        if (this.arr != null) {
            T[] temp = Arrays.copyOf(this.arr, this.arr.length + c.size());
            int i = this.arr.length;
            for (T o : c) {
                temp[i++] = o;
            }
            this.arr = temp;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.list != null) {
            return this.list.addAll(index, c);
        }
        if (this.arr != null) {
            T[] temp = Arrays.copyOf(this.arr, this.arr.length + c.size());
            int i = index;
            for (T o : c) {
                temp[i++] = o;
            }
            while (i < temp.length) {
                temp[i] = this.arr[i - c.size()];
                ++i;
            }
            this.arr = temp;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        if (this.arr != null) {
            this.arr = new Object[0];
        }
    }

    @Override
    public boolean contains(Object o) {
        if (this.list != null) {
            return this.list.contains(o);
        }
        if (this.arr != null) {
            for (T t : this.arr) {
                if (!t.equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.list != null) {
            return this.list.containsAll(c);
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).containsAll(c);
        }
        return false;
    }

    @Override
    public T get(int index) {
        if (this.list != null && index < this.list.size()) {
            return this.list.get(index);
        }
        if (this.arr != null && index < this.arr.length) {
            return this.arr[index];
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (this.list != null) {
            return this.list.indexOf(o);
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).indexOf(o);
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        if (this.list != null) {
            return this.list.isEmpty();
        }
        if (this.arr != null) {
            return this.arr.length <= 0;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.list != null) {
            return this.list.iterator();
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).iterator();
        }
        return null;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.list != null) {
            return this.list.lastIndexOf(o);
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).lastIndexOf(o);
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        if (this.list != null) {
            return this.list.listIterator();
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).listIterator();
        }
        return null;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (this.list != null) {
            return this.list.listIterator(index);
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).listIterator(index);
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.list != null) {
            return this.list.remove(o);
        }
        if (this.arr != null) {
            this.remove(this.indexOf(o));
            return true;
        }
        return false;
    }

    @Override
    public T remove(int index) {
        if (this.list != null) {
            return this.list.remove(index);
        }
        if (this.arr != null) {
            T ret = this.arr[index];
            T[] a1 = Arrays.copyOf(this.arr, this.arr.length - 1);
            System.arraycopy(this.arr, 0, a1, 0, index);
            System.arraycopy(this.arr, index + 1, a1, index, this.arr.length - index - 1);
            this.arr = a1;
            return ret;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.list != null) {
            return this.list.removeAll(c);
        }
        if (this.arr != null) {
            for (Object o : c) {
                this.remove(o);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.list != null) {
            return this.list.retainAll(c);
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).retainAll(c);
        }
        return false;
    }

    @Override
    public T set(int index, T element) {
        if (this.list != null) {
            return this.list.set(index, element);
        }
        if (this.arr != null) {
            this.arr[index] = element;
            return this.arr[index];
        }
        return null;
    }

    @Override
    public int size() {
        if (this.list != null) {
            return this.list.size();
        }
        if (this.arr != null) {
            return this.arr.length;
        }
        return 0;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (this.list != null) {
            return this.list.subList(fromIndex, toIndex);
        }
        if (this.arr != null) {
            return Arrays.asList(this.arr).subList(fromIndex, toIndex);
        }
        return null;
    }

    @Override
    public Object[] toArray() {
        if (this.list != null) {
            return this.list.toArray();
        }
        if (this.arr != null) {
            return this.arr;
        }
        return null;
    }

    @Override
    public <TT> TT[] toArray(TT[] a) {
        if (this.list != null) {
            return this.list.toArray(a);
        }
        if (this.arr != null) {
            return this.arr;
        }
        return null;
    }
}

