/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list.defaultmenu;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Border;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.BorderLineStyle;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ru.infor.beanviewer.core.table.TableWithModel;

public class JExcelWriter {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public static void write(TableWithModel model, String absolutePath, String sheetName) {
        WorkbookSettings ws = new WorkbookSettings();
        ws.setLocale(new Locale("en", "EN"));
        try {
            File bookFile = new File(absolutePath);
            if (bookFile.getParentFile() != null && !bookFile.getParent().isEmpty() && !bookFile.getParentFile().exists()) {
                bookFile.getParentFile().mkdirs();
            }
            WritableWorkbook workbook = Workbook.createWorkbook((File)bookFile, (WorkbookSettings)ws);
            WritableSheet sheet = workbook.createSheet(sheetName, 0);
            JExcelWriter.writeDataSheet(model, sheet);
            workbook.write();
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    private static WritableSheet writeDataSheet(TableWithModel model, WritableSheet sheet) throws RowsExceededException, WriteException {
        if (sheet != null) {
            int firstRow = 0;
            WritableCellFormat cf1 = new WritableCellFormat();
            cf1.setBorder(Border.ALL, BorderLineStyle.THIN);
            cf1.setBackground(Colour.GREY_25_PERCENT);
            for (int i = 0; i < model.getColumnCount(); ++i) {
                Label l = new Label(i, 0, model.getColumnName(i), (CellFormat)cf1);
                sheet.addCell((WritableCell)l);
            }
            ++firstRow;
            WritableCellFormat cf = new WritableCellFormat();
            cf.setBorder(Border.ALL, BorderLineStyle.THIN);
            for (int r = 0; r < model.getRowCount(); ++r) {
                for (int c = 0; c < model.getColumnCount(); ++c) {
                    Label l = new Label(c, firstRow + r, String.valueOf(JExcelWriter.formatData(model.getValueAt(r, c))), (CellFormat)cf);
                    sheet.addCell((WritableCell)l);
                }
            }
            Label l = new Label(0, firstRow + model.getRowCount() + 1, "\u0414\u0430\u0442\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 ", (CellFormat)new WritableCellFormat());
            sheet.addCell((WritableCell)l);
            WritableCellFormat cfd = new WritableCellFormat(DateFormats.FORMAT9);
            DateTime dt = new DateTime(2, firstRow + model.getRowCount() + 1, new Date(), (CellFormat)cfd);
            sheet.addCell((WritableCell)dt);
        }
        return sheet;
    }

    private static char[] formatData(Object valueAt) {
        if (valueAt != null) {
            String str = valueAt.toString();
            if (valueAt instanceof Date) {
                str = dateFormat.format(valueAt);
            }
            if (valueAt instanceof Boolean) {
                Boolean b = (Boolean)valueAt;
                String string = str = b != false ? "\u0434\u0430" : "\u043d\u0435\u0442";
            }
            if (str.startsWith("<")) {
                str = str.replaceAll("<br>", " ").replaceAll("<html>", "");
            }
            return str.toCharArray();
        }
        return "".toCharArray();
    }
}

