/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list.defaultmenu;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.infor.beanviewer.core.table.TableWithModel;

public class TableToXMLWriter {
    static SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public static void write(TableWithModel<?> model, String absolutePath) {
        File xmlFile = new File(absolutePath);
        if (xmlFile.getParentFile() != null && !xmlFile.getParent().isEmpty() && !xmlFile.getParentFile().exists()) {
            xmlFile.getParentFile().mkdirs();
        }
        String[] listTypes = new String[model.getColumnCount()];
        String lf = "\n";
        FileOutputStream out = null;
        try {
            String st = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>";
            out = new FileOutputStream(absolutePath);
            try {
                out.write((st + lf).getBytes());
                String s0 = "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435>";
                st = "<dataxml version=\"1.0\" name=\"" + s0 + "\" createdate=\"" + df.format(new Date()) + "\">";
                out.write((st + lf).getBytes());
                st = "<table columncount=\"" + String.valueOf(model.getColumnCount()).trim() + "\" rowcount=\"" + String.valueOf(model.getRowCount()).trim() + "\">";
                out.write((st + lf).getBytes());
                st = "<columnnames ";
                String stt = "<columntypes ";
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    String s = " n" + String.valueOf(i + 1).trim() + "=\"" + model.getColumnName(i).trim() + "\" ";
                    st = st.concat(s);
                    listTypes[i] = TableToXMLWriter.getColumnType(model.getValueAt(0, i));
                    s = " type" + String.valueOf(i + 1).trim() + "=\"" + listTypes[i] + "\" ";
                    stt = stt.concat(s);
                }
                st = st.concat("/>");
                out.write((st + lf).getBytes());
                stt = stt.concat("/>");
                out.write((stt + lf).getBytes());
                out.write(("<data>" + lf).getBytes());
                for (int r = 0; r < model.getRowCount(); ++r) {
                    st = "<row>";
                    for (int c = 0; c < model.getColumnCount(); ++c) {
                        Object o = model.getValueAt(r, c);
                        String s = " <n" + String.valueOf(c + 1).trim() + ">" + (o instanceof Date ? df.format((Date)o) : String.valueOf(o)) + " </n" + String.valueOf(c + 1).trim() + ">";
                        st = st.concat(s);
                    }
                    st = st.concat("</row>");
                    out.write((st + lf).getBytes());
                }
                out.write(("</data>" + lf).getBytes());
                out.write(("</table>" + lf).getBytes());
                out.write(("</dataxml>" + lf).getBytes());
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static String getColumnType(Object value) {
        String rez = "String";
        if (value instanceof Date) {
            rez = "Date";
        }
        if (value instanceof Double) {
            rez = "Double";
        }
        if (value instanceof Integer) {
            rez = "Integer";
        }
        if (value instanceof Boolean) {
            rez = "Boolean";
        }
        return rez;
    }
}

