/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.list.pagelistviewer;

import java.util.ArrayList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.core.table.TableWithModel;
import ru.infor.beanviewer.swing.viewers.list.TableUIProperties;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.AsyncList;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.beanviewer.viewer.list.ListWithSelection;
import ru.infor.beanviewer.viewer.list.pagelistviewer.PageTableUIProperties;

public class PageListViewer<T>
extends ListViewer<T> {
    T btNext;
    T btPrev;
    T label;
    T labelAll;
    T comboboxPage;
    T panel;
    int page = 0;

    public PageListViewer(UIFactory<T> factory) {
        super(factory);
        this.panel = factory.getPanelInManager();
        this.getFactory().putObjectToContainer(this.getFactory().getLabel("\u0412\u0441\u0435\u0433\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446: "), this.panel, "");
        this.labelAll = this.getFactory().getLabel("0");
        this.getFactory().putObjectToContainer(this.labelAll, this.panel, "");
        this.getFactory().putObjectToContainer(this.getFactory().getLabel("   \u0422\u0435\u043a\u0443\u0449\u0430\u044f:"), this.panel, "");
        BeanViewerAction<ViewerContext> prev = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                PageListViewer.this.setCurrentPage(PageListViewer.this.page - 1);
            }
        };
        prev.setName("<");
        prev.setHint("\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430");
        this.btPrev = this.getFactory().getAction(prev, this.btPrev);
        this.getFactory().putObjectToContainer(this.btPrev, this.panel, "");
        this.getFactory().setComponentEditable(this.btPrev, false);
        this.getFactory().putObjectToContainer(this.getFactory().getLabel("  "), this.panel, "");
        this.label = this.getFactory().getLabel("1");
        this.getFactory().putObjectToContainer(this.label, this.panel, "");
        this.getFactory().putObjectToContainer(this.getFactory().getLabel("  "), this.panel, "");
        BeanViewerAction<ViewerContext> next = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                PageListViewer.this.setCurrentPage(PageListViewer.this.page + 1);
            }
        };
        next.setName(">");
        next.setHint("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430");
        this.btNext = this.getFactory().getAction(next, this.btNext);
        this.getFactory().putObjectToContainer(this.btNext, this.panel, "");
        this.getFactory().setComponentEditable(this.btNext, false);
        this.getFactory().putObjectToContainer(this.getFactory().getLabel("\u041f\u0435\u0440\u0435\u0439\u0442\u0438"), this.panel, "");
        this.comboboxPage = this.getFactory().getComboBox(null);
        this.getFactory().putObjectToContainer(this.comboboxPage, this.panel, "");
        BeanViewerAction<ViewerContext> got = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                Integer p = (Integer)PageListViewer.this.getFactory().getSelectedItem(PageListViewer.this.comboboxPage);
                PageListViewer.this.setCurrentPage(p - 1);
            }
        };
        got.setName("\u041e\u041a");
        got.setHint("\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435");
        Object btGo = null;
        btGo = this.getFactory().getAction(got, btGo);
        this.getFactory().putObjectToContainer(btGo, this.panel, "");
        this.getFactory().setComponentEditable(btGo, true);
    }

    public int getRows() {
        return ((PageTableUIProperties)this.getUIProperties()).getRows();
    }

    public int getPages() {
        int k = this.getTM().list.size();
        int r = this.getRows();
        int p = k / r;
        if (k > 0 && k % r > 0) {
            ++p;
        }
        return p;
    }

    public int getCurrentPage() {
        return this.page;
    }

    public void setCurrentPageWithoutRefresh(int p) {
        this.page = p;
        this.getFactory().setComponentEditable(this.btNext, true);
        this.getFactory().setComponentEditable(this.btPrev, true);
        if (this.page == 0) {
            this.getFactory().setComponentEditable(this.btPrev, false);
        }
        if (this.page >= this.getPages() - 1) {
            this.getFactory().setComponentEditable(this.btNext, false);
        }
        this.getFactory().setTextToComponent(this.label, Integer.toString(this.page + 1));
        this.updateCountLabel("");
    }

    public void setCurrentPage(int p) {
        this.getTM().clearSelection();
        if (this.getTM().list instanceof ListWithSelection) {
            ((ListWithSelection)((Object)this.getTM().list)).setSelectTo(null);
        }
        this.setCurrentPageWithoutRefresh(p);
        super.dataChanged(null);
        if (this.getTM().list.size() > 0) {
            this.getTM().setSelectedRowsTable(new int[]{0});
        }
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        Object t = super.getComponent(isSelected, hasFocus);
        this.getFactory().addSouthPanelToBigPanel(t, this.panel);
        return t;
    }

    @Override
    public TableWithModel<T> getTM() {
        if (this.tm == null) {
            super.getTM();
            this.tm.setExtendedObject(new PageExtendedObject(this.tm, this));
        }
        return this.tm;
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        if (!(viewerProperty instanceof PageTableUIProperties) && viewerProperty instanceof TableUIProperties) {
            PageTableUIProperties p = new PageTableUIProperties();
            TableUIProperties t = (TableUIProperties)viewerProperty;
            p.setAutomaticWidthAjust(t.isAutomaticWidthAjust());
            p.setColumns(t.getColumns());
            super.setUIProperties(p);
        } else {
            super.setUIProperties(viewerProperty);
        }
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return PageTableUIProperties.class;
    }

    @Override
    public Object getNewUiProperties() {
        return new PageTableUIProperties();
    }

    @Override
    public void setBValue(Object value) {
        int k;
        super.setBValue(value);
        if (value instanceof AsyncList) {
            ((AsyncList)value).setPageSize(this.getRows());
        }
        this.getFactory().setComponentEditable(this.btNext, true);
        this.getFactory().setComponentEditable(this.btPrev, true);
        if (this.page == 0) {
            this.getFactory().setComponentEditable(this.btPrev, false);
        }
        if (this.page >= (k = this.getPages()) - 1) {
            this.getFactory().setComponentEditable(this.btNext, false);
        }
        if (this.page >= k && this.page > 0) {
            this.setCurrentPage(k - 1);
        }
    }

    @Override
    protected void updateCountLabel(String text) {
        int b = this.page * this.getRows() + 1;
        if (this.getTM().list.size() == 0) {
            b = 0;
        }
        int e = (this.page + 1) * this.getRows();
        if (this.page >= this.getPages() - 1) {
            e = this.getTM().list.size();
        }
        String k = "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 " + this.getTM().list.size();
        k = k + "/\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043e \u0441 " + Integer.toString(b) + " \u043f\u043e " + Integer.toString(e);
        this.getFactory().setTextToComponent(this.labelAll, Integer.toString(this.getPages()));
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 1; i <= this.getPages(); ++i) {
            l.add(i);
        }
        this.getFactory().setItemsToComboBox(this.comboboxPage, l, this.page + 1);
        super.updateCountLabel(k);
    }

    @Override
    public void dataChanged(Object message) {
        this.getTM().clearSelection();
        super.dataChanged(message);
        this.setCurrentPage(0);
    }

    public static class PageExtendedObject<T>
    extends TableWithModel.WorkExtendedObject<T> {
        PageListViewer<T> listViewer;

        public PageExtendedObject(TableWithModel<T> tm, PageListViewer<T> v) {
            super(tm);
            this.listViewer = v;
        }

        @Override
        public int getRowCount() {
            int k = super.getRowCount();
            int r = this.listViewer.getRows();
            int p = this.listViewer.getCurrentPage();
            int pp = this.listViewer.getPages();
            if (k == 0) {
                return 0;
            }
            if (p == pp - 1) {
                return k - r * p;
            }
            return r;
        }

        @Override
        public int getRowInTable(int rowList) {
            int r = this.listViewer.getRows();
            int p = this.listViewer.getCurrentPage();
            this.listViewer.setCurrentPageWithoutRefresh(p);
            int i = rowList - p * r;
            return i;
        }

        @Override
        public int getRowInTablePosition(int rowList) {
            int r = this.listViewer.getRows();
            int p = rowList / r;
            this.listViewer.setCurrentPageWithoutRefresh(p);
            int i = rowList - p * r;
            return i;
        }

        @Override
        public int getRowInList(int rowTable) {
            int p = this.listViewer.getCurrentPage();
            int r = this.listViewer.getRows();
            int i = rowTable + p * r;
            return i;
        }

        @Override
        public boolean canInnerSort() {
            return false;
        }
    }
}

