/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.BaseNode;
import ru.infor.beanviewer.viewer.menu.IMenu;
import ru.infor.beanviewer.viewer.menu.MenuAction;

@ListView(views={@View(title="\u041c\u0435\u043d\u044e")})
public class Menu
implements BaseNode {
    private static final long serialVersionUID = -6853545950047330985L;
    private List<Menu> submenus = new ArrayList<Menu>();
    private List<MenuAction> actions;
    private String name;
    private Integer order = 0;
    private Menu parent;
    private Integer copyName2Panel = 0;
    private boolean divider = false;
    private Long id;

    public Integer getCopyName2Panel() {
        return this.copyName2Panel;
    }

    public void setCopyName2Panel(Integer copyName2Panel) {
        this.copyName2Panel = copyName2Panel;
    }

    @ListField(fields={@Field(title="\u0420\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c", order=10)})
    public boolean isDivider() {
        return this.divider;
    }

    public void setDivider(boolean divider) {
        this.divider = divider;
    }

    public Menu() {
    }

    public Menu(IMenu imenu) {
        if (imenu == null) {
            return;
        }
        this.setOrderNode(imenu.getOrder());
        this.setDivider(imenu.isDivider());
        if (!this.isDivider()) {
            this.setName(imenu.getName());
            this.id = imenu.getId();
            if (imenu.getSubmenus() != null && imenu.getSubmenus().size() > 0) {
                for (IMenu i : imenu.getSubmenus()) {
                    Menu submenu = new Menu(i);
                    submenu.parent = this;
                    this.submenus.add(submenu);
                }
                Collections.sort(this.submenus);
            }
            if (imenu.getActions() != null) {
                this.actions = imenu.getActions();
                if (this.actions != null) {
                    Collections.sort(this.actions);
                }
            }
        }
    }

    public IMenu setToIMenu(IMenu imenu) {
        imenu.setOrder(this.getOrderNode());
        imenu.setDivider(this.isDivider());
        if (this.isDivider()) {
            return imenu;
        }
        imenu.setName(this.getName());
        ArrayList<IMenu> subs = new ArrayList<IMenu>();
        for (BaseNode baseNode : this.getChildren()) {
            boolean installed = false;
            if (imenu.getSubmenus() == null) {
                imenu.setSubmenus(new ArrayList<IMenu>());
            }
            for (IMenu imenu2 : imenu.getSubmenus()) {
                if (((Menu)baseNode).id == null || !((Menu)baseNode).id.equals(imenu2.getId())) continue;
                subs.add(((Menu)baseNode).setToIMenu(imenu2));
                installed = true;
                break;
            }
            if (installed) continue;
            subs.add(((Menu)baseNode).setToIMenu(imenu.createSubmenu()));
        }
        imenu.setSubmenus(subs);
        imenu.setActions(this.getActions());
        return imenu;
    }

    @Override
    public BaseNode addChild(BaseNode child) {
        this.submenus.add((Menu)child);
        ((Menu)child).parent = this;
        Collections.sort(this.submenus);
        return child;
    }

    public Enumeration<Menu> children() {
        return new Enumeration<Menu>(){
            Iterator<Menu> i;
            {
                this.i = Menu.this.submenus.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public Menu nextElement() {
                return this.i.next();
            }
        };
    }

    @Override
    public int compareTo(BaseNode o) {
        return this.order == null ? 0 : this.order.compareTo(((Menu)o).getOrderNode() == null ? 0 : ((Menu)o).getOrderNode());
    }

    @ListField(fields={@Field(title="\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f", content=MenuAction.class)})
    public List<MenuAction> getActions() {
        if (this.actions == null) {
            return null;
        }
        Collections.sort(this.actions);
        return this.actions;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public BaseNode getChildAt(int childIndex) {
        return this.submenus.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.submenus.size();
    }

    @Override
    public List<? extends BaseNode> getChildren() {
        return this.submenus;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.submenus.indexOf(node);
    }

    @Override
    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", order=20)})
    public String getName() {
        return this.isDivider() ? "----" : this.name;
    }

    @Override
    @ListField(fields={@Field(title="\u041f\u043e\u0440\u044f\u0434\u043e\u043a", order=20)})
    public Integer getOrderNode() {
        return this.order;
    }

    @Override
    public BaseNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void moveChild(BaseNode child) {
        Menu subchild = (Menu)child;
        ((Menu)subchild.getParent()).removeChild(child);
        this.addChild(subchild);
    }

    @Override
    public void removeAllChildren() {
        this.submenus.clear();
    }

    @Override
    public void removeChild(BaseNode child) {
        this.submenus.remove(child);
    }

    public void setActions(List<MenuAction> actions) {
        this.actions = new ArrayList<MenuAction>(actions);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOrderNode(Integer order) {
        this.order = order;
    }

    public String toString() {
        return this.getName();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

