/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.infor.beanviewer.core.BaseDirectoryPresentator;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;

public abstract class BaseDirectoryViewer<T>
extends FieldViewer<T>
implements BaseDirectoryPresentator,
SwingItem {
    T panel = this.getFactory().getPanel();
    protected T comboBox = this.getFactory().getComboBox(this);
    T label = this.getFactory().getLabel("");
    private boolean empty = false;
    protected static HashMap<String, List<?>> itemsMap = new HashMap();

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
        this.getFactory().addActionToComponent(this.comboBox, changeAction);
    }

    @Override
    public void setChangeValueActionOnEnter(BeanViewerAction changeAction) {
        this.getFactory().addActionToComponentOnEnter(this.comboBox, changeAction);
    }

    public BaseDirectoryViewer(UIFactory<T> factory) {
        super(factory);
        factory.setPropertyToComponent("opaque", "true", this.label);
        factory.setPropertyToComponent("background", "#FFFFFF", this.label);
        factory.setPropertyToComponent("border", "true", this.label);
        this.setEditable(true);
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public void setFocus() {
        if (this.isEditable()) {
            this.getFactory().setFocusOnComponent(this.comboBox);
        } else {
            this.getFactory().setFocusOnComponent(this.label);
        }
    }

    protected abstract List<?> getDirectoryItems();

    @Override
    public void setEmptyItemPresent(boolean empty) {
        this.empty = empty;
    }

    @Override
    public void setKey(String key) {
        super.setKey(key);
        key = this.getContentClass().getName() + this.getKey();
        try {
            List<?> i = itemsMap.get(key);
            if (i == null) {
                i = this.getDirectoryItems();
                if (i == null) {
                    i = new ArrayList();
                }
                if (this.empty) {
                    i.add(null);
                }
                itemsMap.put(this.getContentClass().getName() + this.getKey(), i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setValue(Object object) {
        String key = this.getContentClass().getName() + this.getKey();
        List<?> i = itemsMap.get(key);
        if (i == null || i.size() == 0 || this.empty && i.size() == 1 && i.get(0) == null) {
            i = this.getDirectoryItems();
            if (i == null) {
                i = new ArrayList();
            }
            if (this.empty) {
                i.add(null);
            }
            itemsMap.put(this.getContentClass().getName() + this.getKey(), i);
        }
        this.getFactory().setItemsToComboBox(this.comboBox, i, object);
        this.getFactory().setTextToComponent(this.label, object == null ? "" : object.toString());
    }

    public void clearCache() {
        Object o = this.getValue();
        BaseDirectoryViewer.clearCache(this.getContentClass().getName());
        this.setValue(o);
    }

    public static void clearCache(String clazz) {
        ArrayList<String> d = new ArrayList<String>(itemsMap.keySet());
        for (int i = 0; i < d.size(); ++i) {
            if (!((String)d.get(i)).startsWith(clazz)) continue;
            itemsMap.remove(d.get(i));
        }
    }

    @Override
    public Object getValue() {
        return this.getFactory().getSelectedItem(this.comboBox);
    }

    @Override
    public void setPropertyUI(String key, String value) {
        this.getFactory().setPropertyToComponent(key, value, this.label);
        this.getFactory().setPropertyToComponent(key, value, this.comboBox);
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.isEditable() != editable) {
            super.setEditable(editable);
            this.getFactory().clearContainer(this.panel);
            if (editable) {
                this.getFactory().putObjectToContainer(this.comboBox, this.panel, "growx, width 20::");
            } else {
                this.getFactory().putObjectToContainer(this.label, this.panel, "growx, width 20::");
            }
        }
    }

    @Override
    public Class getTableCellViewerClass() {
        return DefaultTableCellViewer.class;
    }
}

