/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import ru.infor.beanviewer.core.DefaultViewer;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.validator.Validator;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class BigDecimalViewer<T>
extends DefaultViewer<T>
implements SwingItem {
    BigDecimal bd;
    ViewerContext bvac;
    private String format = null;
    public final int DEFAULT_SCALE = 4;
    private Integer scale = null;
    DecimalFormat df;

    public BigDecimalViewer(UIFactory<T> factory) {
        super(factory);
        this.init();
    }

    private void init() {
        this.getFactory().setPropertyToComponent("minsize", "100x24", this.jtf);
        this.getFactory().setPropertyToComponent("background", "#FFFFFF", this.jtf);
        this.getFactory().setHorizontalAlignmentToTextField(this.getComponent(false, false), "RIGHT");
        this.getFactory().setActionOnFocusComponent(this.jtf, new BeanViewerAction(){

            @Override
            public void actionPerformed(Object message) {
                if (BigDecimalViewer.this.isEditable()) {
                    BigDecimalViewer.this.getFactory().selectTextIntoTextField(BigDecimalViewer.this.jtf, null);
                }
            }
        }, true, false);
        this.firstValidatorInstalled = false;
        this.setActionToValidator();
    }

    @Override
    public Object getValue() {
        if (this.format == null) {
            String s = (String)super.getValue();
            return (s = s.replaceAll(",", ".")) == null || s.equals("") ? null : new BigDecimal(s).setScale(this.scale == null ? 4 : this.scale, RoundingMode.HALF_UP);
        }
        String s = this.getFactory().getTextFromComponent(this.jtf);
        s = s.replaceAll(",", ".");
        Number n = null;
        if ("".equals(s)) {
            s = "0";
        }
        try {
            n = this.df.parse(s);
            return new BigDecimal(n.doubleValue()).setScale(this.scale == null ? 4 : this.scale, RoundingMode.HALF_UP);
        }
        catch (ParseException parseException) {
            return new BigDecimal("0").setScale(this.scale == null ? 4 : this.scale, RoundingMode.HALF_UP);
        }
    }

    @Override
    public void setValue(Object object) {
        this.bd = (BigDecimal)object;
        if (this.scale != null) {
            BigDecimal bigDecimal = this.bd = this.bd == null ? null : this.bd.setScale((int)this.scale, 4);
        }
        if (this.format == null) {
            super.setValue(this.bd);
        } else if (this.bd == null) {
            this.getFactory().setTextToComponent(this.jtf, "");
        } else {
            this.getFactory().setTextToComponent(this.jtf, this.df.format(this.bd));
        }
    }

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("scale")) {
            this.scale = Integer.parseInt(value);
            String s = "([-+]){0,1}\\d*\\.{0,1}\\d{0," + (this.scale == null ? 4 : this.scale) + "}";
            try {
                super.addValidator(Validator.getValidator("\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435").newInstance(), "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430", s, "\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (key.toLowerCase().equals("format")) {
            this.format = value;
            DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
            unusualSymbols.setDecimalSeparator('.');
            unusualSymbols.setGroupingSeparator(' ');
            this.df = new DecimalFormat(this.format, unusualSymbols);
        }
        super.setPropertyField(key, value);
    }

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return BigDecimalTableCellViewer.class;
    }

    @Override
    public void setBeanViewerActionContextToValidators(ViewerContext bvac) {
        this.bvac = bvac;
        super.setBeanViewerActionContextToValidators(bvac);
    }

    public static class BigDecimalTableCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public int scale = 2;
        BigDecimal bd;
        private String format = null;
        DecimalFormat df;

        public BigDecimalTableCellViewer(UIFactory<T> factory) {
            super(factory);
            factory.setHorizontalAlignmentToTextField(this.jtf, "RIGHT");
        }

        @Override
        public void setPropertyField(String key, String value) {
            if (key.toLowerCase().equals("scale")) {
                this.scale = Integer.parseInt(value);
            }
            if (key.toLowerCase().equals("format")) {
                this.format = value;
                DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
                unusualSymbols.setDecimalSeparator('.');
                unusualSymbols.setGroupingSeparator(' ');
                this.df = new DecimalFormat(this.format, unusualSymbols);
            }
            super.setPropertyField(key, value);
        }

        @Override
        public void setValue(Object object) {
            this.bd = (BigDecimal)object;
            BigDecimal bigDecimal = this.bd = this.bd == null ? null : this.bd.setScale(this.scale, 4);
            if (this.bd == null) {
                this.getFactory().setComponentSize(this.jtf, 100, 24);
                this.getFactory().setTextToComponent(this.jtf, "");
            } else if (this.format == null) {
                super.setValue(this.bd);
            } else {
                this.getFactory().setTextToComponent(this.jtf, this.df.format(this.bd));
            }
        }
    }
}

