/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.simple.DateViewer;
import ru.infor.lib.misc.CalendarEx;

public class DateExViewer
extends FieldViewer<JComponent>
implements SwingItem {
    CalendarEx dateEx = new CalendarEx();
    JCheckBox checkBox = new JCheckBox();
    JPanel panel = new JPanel(new FlowLayout(0, 0, 0));

    public DateExViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.setEditable(false);
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        this.panel.add(this.checkBox);
        this.panel.add((Component)this.dateEx);
        this.dateEx.setPreferredSize(new Dimension(100, 24));
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public Object getValue() {
        return !this.checkBox.isSelected() ? null : this.dateEx.getDate();
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.dateEx.setEnabled(editable);
        this.checkBox.setEnabled(editable);
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.checkBox.setSelected(false);
        } else {
            this.checkBox.setSelected(true);
            this.dateEx.setDate((Date)object);
        }
        this.changeActionAllPerformed(null);
    }

    @Override
    public Class<? extends FieldViewer<JComponent>> getTableCellViewerClass() {
        return DateViewer.class;
    }

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
        this.dateEx.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DateExViewer.this.changeActionAllPerformed(e);
            }
        });
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateExViewer.this.dateEx.setEnabled(DateExViewer.this.checkBox.isSelected());
                DateExViewer.this.changeActionAllPerformed(e);
            }
        });
    }
}

