/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.DateFormatter;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.simple.DateViewerUIProperties;

public class DateViewer<T>
extends FieldViewer<T>
implements SwingItem {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy");
    private static SimpleDateFormat dateWithTimeFormat = new SimpleDateFormat("dd MMMM yyyy   HH:mm:ss");
    protected Date date;
    protected T field = this.getFactory().getTextField();
    protected SimpleDateFormat realFormat = null;
    private DateViewerUIProperties viewerProperty;

    public DateViewer(UIFactory<T> factory) {
        super(factory);
        this.setEditable(false);
    }

    @Override
    public T getComponent(boolean selected, boolean hasFocus) {
        this.getFactory().setBFColorsToComponent(this.field, selected);
        return this.field;
    }

    @Override
    public Object getUIProperties() {
        return this.viewerProperty;
    }

    @Override
    public Class<?> getUIPropertiesClass() {
        return DateViewerUIProperties.class;
    }

    @Override
    public Object getValue() {
        try {
            if (!this.getFactory().getTextFromComponent(this.field).isEmpty()) {
                this.date = (Date)new DateFormatter(this.realFormat).stringToValue(this.getFactory().getTextFromComponent(this.field));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.date;
    }

    @Override
    public void setChangeValueAction(BeanViewerAction changeAction) {
        this.getFactory().addActionToComponent(this.field, changeAction);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.getFactory().setComponentEditable(this.field, editable);
    }

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("format")) {
            try {
                SimpleDateFormat r;
                this.realFormat = r = new SimpleDateFormat(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setPropertyField(key, value);
    }

    @Override
    public void setUIProperties(Object viewerProperty) {
        this.viewerProperty = (DateViewerUIProperties)viewerProperty;
        this.setPropertyField("format", this.viewerProperty.getFormat());
        String val = "left";
        switch (this.viewerProperty.getHorizontalAlignment()) {
            case 0: {
                val = "center";
                break;
            }
            case 2: {
                val = "left";
                break;
            }
            case 4: {
                val = "right";
            }
        }
        this.getFactory().setPropertyToComponent("horizontalAlignment", val, this.field);
    }

    @Override
    public void setValue(Object object) {
        if (this.realFormat == null) {
            if (object instanceof Date) {
                this.realFormat = dateFormat;
            } else if (object instanceof Timestamp) {
                this.realFormat = dateWithTimeFormat;
            }
        }
        this.date = (Date)object;
        try {
            this.getFactory().setTextToComponent(this.field, new DateFormatter(this.realFormat).valueToString(this.date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (object == null) {
            this.getFactory().setTextToComponent(this.field, "");
        }
        this.getFactory().setEmptyBorderToComponent(this.field);
    }
}

