/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import ru.infor.beanviewer.core.DefaultViewer;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.validator.Validator;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class DoubleViewer<T>
extends DefaultViewer<T>
implements SwingItem {
    Double bd;
    ViewerContext bvac;
    protected String format = null;
    public final int DEFAULT_SCALE = 4;
    private Integer scale = null;
    DecimalFormat df;

    public DoubleViewer(UIFactory<T> factory) {
        super(factory);
        this.init();
    }

    private void init() {
        this.getFactory().setPropertyToComponent("minsize", "100x24", this.jtf);
        this.getFactory().setPropertyToComponent("background", "#FFFFFF", this.jtf);
        this.getFactory().setHorizontalAlignmentToTextField(this.getComponent(false, false), "RIGHT");
        this.getFactory().setActionOnFocusComponent(this.jtf, new BeanViewerAction(){

            @Override
            public void actionPerformed(Object message) {
                if (DoubleViewer.this.isEditable()) {
                    DoubleViewer.this.getFactory().selectTextIntoTextField(DoubleViewer.this.jtf, null);
                }
            }
        }, true, false);
        this.firstValidatorInstalled = false;
        this.setActionToValidator();
    }

    protected Double getDoubleFromString(String s) {
        if (this.format == null) {
            return (s = s.replaceAll(",", ".")) == null || s.equals("") ? null : Double.valueOf(Double.parseDouble(s));
        }
        s = s.replaceAll(",", ".");
        Number n = null;
        if ("".equals(s)) {
            s = "0";
        }
        try {
            n = this.df.parse(s);
            return n.doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    @Override
    public Object getValue() {
        String s = (String)super.getValue();
        return this.getDoubleFromString(s);
    }

    @Override
    public void setValue(Object object) {
        this.bd = (Double)object;
        if (this.scale != null) {
            Double d = this.bd = this.bd == null ? null : this.bd;
        }
        if (this.bd == null) {
            this.getFactory().setComponentSize(this.jtf, 100, 24);
        }
        this.getFactory().setTextToComponent(this.jtf, this.getStringFromDouble(this.bd));
    }

    protected String getStringFromDouble(Double bd) {
        if (bd == null) {
            return "";
        }
        if (this.format == null) {
            return bd.toString();
        }
        return this.df.format(bd);
    }

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("scale")) {
            this.scale = Integer.parseInt(value);
            String s = "([-+]){0,1}\\d*\\.{0,1}\\d{0," + (this.scale == null ? 4 : this.scale) + "}";
            try {
                super.addValidator(Validator.getValidator("\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435").newInstance(), "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430", s, "\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (key.toLowerCase().equals("format")) {
            this.format = value;
            DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
            unusualSymbols.setDecimalSeparator('.');
            unusualSymbols.setGroupingSeparator(' ');
            this.df = new DecimalFormat(this.format, unusualSymbols);
        }
        super.setPropertyField(key, value);
    }

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return DoubleTableCellViewer.class;
    }

    @Override
    public void setBeanViewerActionContextToValidators(ViewerContext bvac) {
        this.bvac = bvac;
        super.setBeanViewerActionContextToValidators(bvac);
    }

    public static class DoubleTableCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public int scale = 2;
        Double bd;
        private String format = null;
        DecimalFormat df;

        public DoubleTableCellViewer(UIFactory<T> factory) {
            super(factory);
            factory.setHorizontalAlignmentToTextField(this.jtf, "RIGHT");
        }

        @Override
        public void setPropertyField(String key, String value) {
            if (key.toLowerCase().equals("scale")) {
                this.scale = Integer.parseInt(value);
            }
            if (key.toLowerCase().equals("format")) {
                this.format = value;
                DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
                unusualSymbols.setDecimalSeparator('.');
                unusualSymbols.setGroupingSeparator(' ');
                this.df = new DecimalFormat(this.format, unusualSymbols);
            }
            super.setPropertyField(key, value);
        }

        @Override
        public void setValue(Object object) {
            this.bd = (Double)object;
            if (this.bd == null) {
                this.getFactory().setComponentSize(this.jtf, 100, 24);
                this.getFactory().setTextToComponent(this.jtf, "");
            } else if (this.format == null) {
                super.setValue(this.bd);
            } else {
                this.getFactory().setTextToComponent(this.jtf, this.df.format(this.bd));
            }
        }
    }
}

