/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.util.List;
import java.util.logging.Logger;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.DirectoryListPresentation;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public abstract class ExtendedDirectoryViewer<T>
extends FieldViewer<T>
implements SwingItem {
    protected T panel = this.getFactory().getPanel();
    protected T field;
    protected T button;
    Object value;
    protected BeanViewerAction<ViewerContext> dirEditorButton;

    @Override
    public void setTableField(boolean tableField) {
        if (this.button != null) {
            this.getFactory().setPropertyToComponent("border", tableField ? "false" : "true", this.button);
            this.getFactory().setPropertyToComponent("minsize", tableField ? "18x18" : "22x22", this.button);
            this.getFactory().setPropertyToComponent("size", tableField ? "18x18" : "22x22", this.button);
        }
        if (this.field != null) {
            this.getFactory().setPropertyToComponent("border", tableField ? "false" : "true", this.field);
            this.getFactory().setPropertyToComponent("minsize", tableField ? "40x18" : "40x22", this.field);
        }
        super.setTableField(tableField);
    }

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return DefaultTableCellViewer.class;
    }

    public String getKeyViewDirectory() {
        return "";
    }

    public void buttonActionPerfomed() {
        try {
            DirectoryListPresentation dir = this.getPresentationClass().getConstructor(Class.class, List.class).newInstance(this.getContentClass(), this.getDirectoryItems());
            this.getFactory().newPage(this.getContentClass(), this.getPresentationClass(), dir, this.getViewerContext(), this.getKeyViewDirectory());
        }
        catch (Exception e) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public Class<? extends DirectoryListPresentation> getPresentationClass() {
        return DirectoryListPresentation.class;
    }

    public T getFieldEditor() {
        Object ret = this.getFactory().getLabel("");
        return ret;
    }

    protected void init() {
        this.getFactory().clearContainer(this.panel);
        this.field = this.getFieldEditor();
        this.getFactory().putObjectToContainer(this.field, this.panel, "growx");
        this.getFactory().setPropertyToComponent("background", "#FFFFFF", this.panel);
        this.getFactory().setPropertyToComponent("border", "true", this.field);
        this.getFactory().setPropertyToComponent("minsize", "40x22", this.field);
        this.initButton(this.panel);
        this.setEditable(true);
    }

    protected void initButton(T panel) {
        this.dirEditorButton = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                ExtendedDirectoryViewer.this.buttonActionPerfomed();
            }
        };
        this.dirEditorButton.setName("");
        this.dirEditorButton.setIcon("/data/icons/database_edit.png");
        this.dirEditorButton.setHint("\u0412\u044b\u0431\u043e\u0440");
        this.button = this.getFactory().getAction(this.dirEditorButton, this.button);
        this.getFactory().setPropertyToComponent("size", "22x22", this.button);
        this.getFactory().putObjectToContainer(this.button, panel, "width 20:20:20, height 22:22:22");
    }

    public ExtendedDirectoryViewer(UIFactory<T> factory) {
        super(factory);
        this.init();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.getFactory().setVisibleObject(this.button, editable);
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
        this.setTextToComponent(object == null ? "" : this.valueToString(object));
        this.changeActionAllPerformed(null);
    }

    protected void setTextToComponent(String s) {
        this.getFactory().setTextToComponent(this.field, s);
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    public abstract List<?> getDirectoryItems();
}

