/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import javax.swing.JSlider;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class IntSliderViewer<T>
extends FieldViewer<T>
implements SwingItem {
    T slider;

    public IntSliderViewer(UIFactory<T> factory) {
        super(factory);
        this.slider = factory.getSlider(0, 100);
    }

    @Override
    public void setPropertyField(String key, String value) {
        super.setPropertyField(key, value);
        if ("max".equals(key)) {
            ((JSlider)this.slider).setMaximum(Integer.parseInt(value));
        } else if ("min".equals(key)) {
            ((JSlider)this.slider).setMinimum(Integer.parseInt(value));
        }
    }

    @Override
    public T getComponent(boolean isSelected, boolean hasFocus) {
        return this.slider;
    }

    @Override
    public Object getValue() {
        return this.getFactory().getValueFromSlider(this.slider);
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
        this.getFactory().addActionToComponent(this.slider, changeAction);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.getFactory().setComponentEditable(this.slider, editable);
    }

    @Override
    public void setValue(Object object) {
        this.getFactory().setValueToSlider((Integer)object, this.slider);
    }
}

