/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.SliderValue;

public class SliderViewer
extends FieldViewer<JComponent>
implements SwingItem {
    private JSlider slider = new JSlider();
    private JLabel label = new JLabel();
    private JPanel panel = new JPanel(new BorderLayout());
    private SliderValue value;
    private boolean setting = false;

    public SliderViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.panel.setBorder(BorderFactory.createTitledBorder(""));
        this.panel.add((Component)this.label, "West");
        this.panel.add((Component)this.slider, "Center");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SliderViewer.this.setting && SliderViewer.this.value != null) {
                    SliderViewer.this.value.setValue(SliderViewer.this.slider.getValue());
                    SliderViewer.this.label.setText("" + ((JSlider)e.getSource()).getValue());
                    SliderViewer.this.panel.repaint();
                }
            }
        });
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public Class<? extends FieldViewer<JComponent>> getTableCellViewerClass() {
        return DefaultTableCellViewer.class;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.slider.setEnabled(editable);
    }

    @Override
    public void setValue(Object object) {
        this.setting = true;
        if (object == null) {
            this.value = null;
        } else {
            SliderValue newValue = (SliderValue)object;
            if (this.slider.getMaximum() != newValue.getMax().intValue()) {
                this.slider.setMaximum(newValue.getMax());
            }
            if (this.slider.getMinimum() != newValue.getMin()) {
                this.slider.setMinimum(newValue.getMin());
            }
            if (this.slider.getMinorTickSpacing() != newValue.getMinor()) {
                this.slider.setMinorTickSpacing(newValue.getMinor());
            }
            if (this.slider.getMajorTickSpacing() != newValue.getMajor()) {
                this.slider.setMajorTickSpacing(newValue.getMajor());
            }
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            if (this.slider.getValue() != newValue.getValue()) {
                this.slider.setValue(newValue.getValue());
                this.label.setText(object.toString());
            }
            this.value = newValue;
        }
        this.setting = false;
    }

    @Override
    public void setChangeValueAction(final BeanViewerAction changeAction) {
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SliderViewer.this.setting) {
                    changeAction.actionPerformed(null);
                }
            }
        });
    }
}

