/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple.date;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.DateViewer;
import ru.infor.beanviewer.viewer.simple.date.ToggleComponent;
import ru.infor.beanviewer.viewer.simple.date.ToggleManager;
import ru.infor.lib.misc.CalendarEx;

public abstract class DateWithNullValueViewer
extends FieldViewer<JComponent>
implements ToggleComponent,
SwingItem {
    private CalendarEx dateEx = new CalendarEx();
    private JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0"));
    private ToggleManager toggleManager;

    public DateWithNullValueViewer(UIFactory<JComponent> factory) {
        super(factory);
        this.dateEx.setPreferredSize(new Dimension(100, 24));
        this.dateEx.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DateWithNullValueViewer.this.toggleManager.setBooleanValue(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        Component tm = this.getToggleManager(this);
        if (tm instanceof ToggleManager) {
            this.toggleManager = (ToggleManager)((Object)tm);
        }
        this.setEditable(false);
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        this.panel.add((Component)this.dateEx, "growx");
        this.panel.add(tm, "growpriox 0");
    }

    @Override
    public boolean getBooleanValue() {
        return this.getValue() != null;
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public void setFocus() {
        this.getFactory().setFocusOnComponent(this.dateEx.getFormattedTextField());
    }

    @Override
    public Class<? extends FieldViewer<JComponent>> getTableCellViewerClass() {
        return DateViewer.class;
    }

    public abstract Component getToggleManager(ToggleComponent var1);

    @Override
    public Object getValue() {
        return this.dateEx.getDate();
    }

    @Override
    public void setBooleanValue(boolean value) {
        this.dateEx.setDate(!value ? null : this.dateEx.getDate());
        this.changeActionAllPerformed(null);
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
        this.dateEx.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DateWithNullValueViewer.this.changeActionAllPerformed(e);
            }
        });
    }

    @Override
    public void setChangeValueActionOnEnter(BeanViewerAction<ViewerContext> changeAction) {
        this.getFactory().addActionToComponentOnEnter(this.dateEx.getFormattedTextField(), changeAction);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.dateEx.setEnabled(editable);
        ((Component)((Object)this.toggleManager)).setEnabled(editable);
    }

    @Override
    public void setPropertyUI(String key, String value) {
        if (key.toLowerCase().equals("format")) {
            this.setDateFormat(value);
        } else {
            super.setPropertyUI(key, value);
        }
    }

    public void setDateFormat(String dateFormatString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        this.dateEx.setDateFormat(dateFormat);
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            if (this.dateEx.getDate() == null) {
                this.dateEx.setDate(new Date());
            }
            this.dateEx.setDate(null);
        } else {
            this.dateEx.setDate((Date)object);
        }
        for (ActionListener al : this.dateEx.getFormattedTextField().getActionListeners()) {
            al.actionPerformed(null);
        }
        this.changeActionAllPerformed(null);
    }
}

