/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple.date;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.swing.SwingItem;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.DateViewer;
import ru.infor.lib.misc.CalendarEx;

public class DateWithoutButton
extends FieldViewer<JComponent>
implements SwingItem {
    private BeanViewerAction<ViewerContext> action;
    private CalendarEx dateEx = new CalendarEx();
    private JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0"));

    public DateWithoutButton(UIFactory<JComponent> factory) {
        super(factory);
        this.dateEx.setPreferredSize(new Dimension(100, 24));
        this.setEditable(false);
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        this.panel.add((Component)this.dateEx, "growx");
    }

    @Override
    public JComponent getComponent(boolean isSelected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public void setFocus() {
        this.getFactory().setFocusOnComponent(this.dateEx);
    }

    @Override
    public Class<? extends FieldViewer<JComponent>> getTableCellViewerClass() {
        return DateViewer.class;
    }

    @Override
    public Object getValue() {
        return this.dateEx.getDate();
    }

    public void setBooleanValue(boolean value) {
        this.dateEx.setDate(!value ? null : this.dateEx.getDate());
        if (this.action != null) {
            this.action.actionPerformed(value);
        }
    }

    @Override
    public void setChangeValueAction(BeanViewerAction<ViewerContext> changeAction) {
        this.dateEx.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DateWithoutButton.this.changeActionAllPerformed(e);
            }
        });
    }

    @Override
    public void setChangeValueActionOnEnter(BeanViewerAction<ViewerContext> changeAction) {
        this.dateEx.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DateWithoutButton.this.changeActionAllPerformed(e);
            }
        });
        this.action = changeAction;
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.dateEx.setEnabled(editable);
    }

    @Override
    public void setPropertyUI(String key, String value) {
        if (key.toLowerCase().equals("format")) {
            this.setDateFormat(value);
        } else {
            super.setPropertyUI(key, value);
        }
    }

    public void setDateFormat(String dateFormatString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        this.dateEx.setDateFormat(dateFormat);
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            this.dateEx.setDate(null);
        } else {
            this.dateEx.setDate((Date)object);
        }
        for (ActionListener al : this.dateEx.getFormattedTextField().getActionListeners()) {
            al.actionPerformed(null);
        }
        this.changeActionAllPerformed(null);
    }
}

