/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.beanviewer.viewer.simple.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.text.DateFormatter;
import ru.infor.beanviewer.core.FieldViewer;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.simple.DateViewer;

public class TimeViewer<T>
extends DateViewer<T> {
    T panel = this.getFactory().getPanel();
    private BeanViewerAction<ViewerContext> buttonClear;
    T button;
    Calendar calendar = Calendar.getInstance();

    public TimeViewer(UIFactory<T> factory) {
        super(factory);
        this.setPropertyField("format", "HH:mm:ss");
        this.getFactory().setPropertyToComponent("minsize", "40x22", this.field);
        this.getFactory().setPropertyToComponent("background", "#FFFFFF", this.field);
        this.getFactory().putObjectToContainer(this.field, this.panel, "growx");
        this.buttonClear = new BeanViewerAction<ViewerContext>(){

            @Override
            public void actionPerformed(Object message) {
                TimeViewer.this.setValue(null);
            }
        };
        this.buttonClear.setName("X");
        this.buttonClear.setHint("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        this.button = this.getFactory().getAction(this.buttonClear, this.button);
        this.getFactory().putObjectToContainer(this.button, this.panel, "width 42, height 22:22:22");
    }

    private Date getDefaultValue() {
        this.calendar.setTime(new Date());
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    @Override
    public void setPropertyField(String key, String value) {
        if (key.toLowerCase().equals("format")) {
            this.realFormat = new SimpleDateFormat(value);
            this.getFactory().setPropertyToComponent("hint", value, this.field);
        }
        super.setPropertyField(key, value);
    }

    @Override
    public Class<? extends FieldViewer<T>> getTableCellViewerClass() {
        return DateViewer.class;
    }

    @Override
    public Object getValue() {
        try {
            if (this.getFactory().getTextFromComponent(this.field).isEmpty()) {
                return null;
            }
            this.calendar.setTime(this.date);
            Calendar c2 = Calendar.getInstance();
            c2.setTime((Date)new DateFormatter(this.realFormat).stringToValue(this.getFactory().getTextFromComponent(this.field)));
            this.calendar.set(11, c2.get(11));
            this.calendar.set(12, c2.get(12));
            this.calendar.set(13, c2.get(13));
            this.calendar.set(14, c2.get(14));
            this.date = this.calendar.getTime();
            this.setValue(this.date);
        }
        catch (Exception e) {
            this.setValue(this.date);
        }
        return this.date;
    }

    @Override
    public T getComponent(boolean selected, boolean hasFocus) {
        return this.panel;
    }

    @Override
    public void setValue(Object object) {
        this.date = object == null ? this.getDefaultValue() : (Date)object;
        try {
            this.getFactory().setTextToComponent(this.field, new DateFormatter(this.realFormat).valueToString(this.date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

