/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.mail;

import com.sun.mail.smtp.SMTPTransport;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import ru.infor.mail.Sender;

public class TextMailSender
implements Sender {
    private Transport tr;
    private Message msg;
    private Session sn;
    private String host;
    private Integer port;
    private String login;
    private String password;
    private String mailTo;
    private String mailFrom;

    @Override
    public void send(String subject, String message) throws Exception {
        this.setMessage(this.mailFrom, this.mailTo, subject, message);
        if (this.login != null && this.login.equals("")) {
            this.login = null;
        }
        if (this.password != null && this.password.equals("")) {
            this.password = null;
        }
        this.setSMTPServer(this.host, this.port, this.login, this.password);
        this.send();
    }

    public void setMessage(String fromAddress, String toAddress, String subject, String content) throws Exception {
        String[] addresses = new String[]{toAddress};
        this.setMessage(fromAddress, addresses, subject, content);
    }

    public void setMessage(String fromAddress, String[] toAddresses, String subject, String content) throws Exception {
        this.sn = Session.getInstance((Properties)System.getProperties());
        this.msg = new MimeMessage(this.sn);
        this.msg.setFrom((Address)new InternetAddress(fromAddress));
        InternetAddress[] toIntAdds = new InternetAddress[toAddresses.length];
        for (int i = 0; i < toAddresses.length; ++i) {
            toIntAdds[i] = new InternetAddress(toAddresses[i]);
        }
        this.msg.setRecipients(Message.RecipientType.TO, (Address[])toIntAdds);
        this.msg.setSubject(subject);
        this.msg.setSentDate(new Date());
        this.msg.setText(content);
    }

    public void setSMTPServer(String host, int port, String user, String password) throws Exception {
        this.tr = new SMTPTransport(this.sn, new URLName(host));
        this.tr.connect(host, port, null, null);
    }

    public void send() throws Exception {
        this.msg.saveChanges();
        this.tr.sendMessage(this.msg, this.msg.getAllRecipients());
        this.tr.close();
    }

    public static void main(String[] args) throws Exception {
        TextMailSender tms = new TextMailSender();
        tms.setMessage("swapan_java_api_prog@swapan.net.uk", new String[]{"jitesh.india@mailbox123.com", "dey_swapan@swapan2.com"}, "test mail", "Boss, I am sendingthis mail from my java program. The from id doesn't exists but you can reply this mail to my official id");
        tms.setSMTPServer("localhost", 25, null, null);
        tms.send();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public void setMailFrom(String mailFrom) {
        this.mailFrom = mailFrom;
    }
}

