/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.DWithin;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class FilterTransformer
extends DuplicatingFilterVisitor {
    static final Logger LOGGER = Logging.getLogger(FilterTransformer.class);
    MathTransform mt;
    CoordinateReferenceSystem fromCRS;
    CoordinateReferenceSystem toCRS;

    public FilterTransformer(MathTransform mt) {
        this.mt = mt;
    }

    public FilterTransformer(FilterFactory2 ff, MathTransform mt) {
        super(ff);
        this.mt = mt;
    }

    public FilterTransformer(CoordinateReferenceSystem fromCRS, CoordinateReferenceSystem toCRS, MathTransform affineTransform) throws FactoryException {
        this.fromCRS = fromCRS;
        this.toCRS = toCRS;
        try {
            this.mt = CRS.findMathTransform((CoordinateReferenceSystem)fromCRS, (CoordinateReferenceSystem)toCRS);
        }
        catch (Exception e) {
            this.mt = null;
        }
        this.mt = this.mt == null ? affineTransform : ReferencingFactoryFinder.getMathTransformFactory(null).createConcatenatedTransform(this.mt, affineTransform);
        if (this.mt == null) {
            this.mt = ReferencingFactoryFinder.getMathTransformFactory(null).createAffineTransform((Matrix)new Matrix2(1.0, 0.0, 0.0, 1.0));
        }
    }

    public Object visit(BBOX filter, Object extraData) {
        String propertyName = filter.getPropertyName();
        double[] coords = new double[]{filter.getMinX(), filter.getMinY(), filter.getMaxX(), filter.getMaxY()};
        String srs = filter.getSRS();
        double[] dest = new double[4];
        try {
            this.mt.transform(coords, 0, dest, 0, 2);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        return this.getFactory(extraData).bbox(propertyName, dest[0], dest[1], dest[2], dest[3], srs);
    }

    public Object visit(Beyond filter, Object extraData) {
        double distance = filter.getDistance();
        if (filter.getExpression1() instanceof Literal) {
            Literal transformed = this.bufferTransformGeometry((Literal)filter.getExpression1(), distance, extraData);
            return this.getFactory(extraData).disjoint((Expression)transformed, filter.getExpression2());
        }
        if (filter.getExpression2() instanceof Literal) {
            Literal transformed = this.bufferTransformGeometry((Literal)filter.getExpression2(), distance, extraData);
            return this.getFactory(extraData).disjoint(filter.getExpression1(), (Expression)transformed);
        }
        LOGGER.log(Level.WARNING, "Could not transform this filter because it does not use a geometry literal: {0}.\nThe resulting of filtering will be most likely wrong", new Object[]{filter});
        return filter;
    }

    public Object visit(DWithin filter, Object extraData) {
        double distance = filter.getDistance();
        if (filter.getExpression1() instanceof Literal) {
            Literal transformed = this.bufferTransformGeometry((Literal)filter.getExpression1(), distance, extraData);
            return this.getFactory(extraData).intersects((Expression)transformed, filter.getExpression2());
        }
        if (filter.getExpression2() instanceof Literal) {
            Literal transformed = this.bufferTransformGeometry((Literal)filter.getExpression2(), distance, extraData);
            return this.getFactory(extraData).intersects(filter.getExpression1(), (Expression)transformed);
        }
        LOGGER.log(Level.WARNING, "Could not transform this filter because it does not use a geometry literal: {0}.\nThe resulting of filtering will be most likely wrong", new Object[]{filter});
        return filter;
    }

    private Literal bufferTransformGeometry(Literal geomLiteral, double distance, Object extraData) {
        try {
            Geometry geometry = (Geometry)geomLiteral.evaluate(null, Geometry.class);
            Geometry buffered = geometry.buffer(distance);
            Geometry transformed = JTS.transform((Geometry)buffered, (MathTransform)this.mt);
            return this.getFactory(extraData).literal((Object)transformed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(Literal expression, Object extraData) {
        Object value = expression.getValue();
        try {
            if (value instanceof Geometry) {
                return this.getFactory(extraData).literal((Object)JTS.transform((Geometry)((Geometry)value), (MathTransform)this.mt));
            }
            if (value instanceof Envelope) {
                ReferencedEnvelope start = new ReferencedEnvelope((Envelope)value, this.toCRS);
                return this.getFactory(extraData).literal((Object)JTS.transform((Envelope)start, (MathTransform)this.mt));
            }
        }
        catch (MismatchedDimensionException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalFilterException e) {
            throw new RuntimeException(e);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        return super.visit(expression, extraData);
    }
}

