/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape.shapehandler.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class PolygonHandler
extends org.geotools.renderer.shape.shapehandler.simple.PolygonHandler {
    private static final LinearRing[] HOLES = new LinearRing[0];
    private static final GeometryFactory factory = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());

    public PolygonHandler(ShapeType type, Envelope env, MathTransform mt, boolean hasOpacity) throws TransformException {
        super(type, env, mt, hasOpacity);
    }

    @Override
    protected Object createGeometry(ShapeType type, Envelope geomBBox, double[][] transformed) {
        Polygon[] poly = new Polygon[transformed.length];
        for (int i = 0; i < transformed.length; ++i) {
            LinearRing ring = factory.createLinearRing((CoordinateSequence)new LiteCoordinateSequence(transformed[i]));
            poly[i] = factory.createPolygon(ring, HOLES);
        }
        return factory.createMultiPolygon(poly);
    }

    private static class PolygonCoodinateSequence
    implements CoordinateSequence {
        final double[] coords;
        volatile Coordinate[] array;

        public PolygonCoodinateSequence(double[] ds) {
            this.coords = ds;
        }

        public Envelope expandEnvelope(Envelope env) {
            for (int i = 0; i < this.coords.length; i += 2) {
                env.expandToInclude(this.coords[i], this.coords[i + 1]);
            }
            return env;
        }

        public Coordinate getCoordinate(int i) {
            int offset = i * 2;
            return new Coordinate(this.coords[offset], this.coords[offset + 1]);
        }

        public void getCoordinate(int index, Coordinate coord) {
            int offset = index * 2;
            coord.x = this.coords[offset];
            coord.y = this.coords[offset + 1];
        }

        public Coordinate getCoordinateCopy(int i) {
            return this.getCoordinate(i);
        }

        public int getDimension() {
            return 2;
        }

        public double getOrdinate(int index, int ordinateIndex) {
            return this.coords[index * 2 + ordinateIndex];
        }

        public double getX(int index) {
            return this.coords[index * 2];
        }

        public double getY(int index) {
            return this.coords[index * 2 + 1];
        }

        public void setOrdinate(int index, int ordinateIndex, double value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.coords.length / 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Coordinate[] toCoordinateArray() {
            if (this.array == null) {
                PolygonCoodinateSequence polygonCoodinateSequence = this;
                synchronized (polygonCoodinateSequence) {
                    if (this.array == null) {
                        this.array = new Coordinate[this.size()];
                        for (int i = 0; i < this.array.length * 2; i += 2) {
                            this.array[i / 2] = new Coordinate(this.coords[i], this.coords[i + 1]);
                        }
                    }
                }
            }
            return this.array;
        }

        public Object clone() {
            try {
                PolygonCoodinateSequence other = (PolygonCoodinateSequence)super.clone();
                return other;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

