/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.sip;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.apache.felix.main.Main;
import ru.infor.sip.VOIPLink;
import ru.infor.sip.wsdl.OSGiService;
import ru.infor.sip.wsdl1.OperationFailedException_Exception;
import ru.infor.sip.wsdl1.ParseException_Exception;
import ru.infor.sip.wsdl1.VOIP;
import ru.infor.sip.wsdl1.VOIPService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService
public class OSGi {
    public static final String PNAME_SC_HOME_DIR_LOCATION = "net.java.sip.communicator.SC_HOME_DIR_LOCATION";
    public static final String PNAME_SC_HOME_DIR_NAME = "net.java.sip.communicator.SC_HOME_DIR_NAME";
    private static String overridableDirName = "vms";
    private static String[] legacyDirNames = new String[]{".vms", "VMS"};
    private static String[] legacyConfigurationFileNames = new String[]{"vms-communicator.properties", "vms.properties", "vms-communicator.xml", "vms.xml"};
    private static VOIPLink il;
    private static ru.infor.sip.wsdl.OSGi voip_out;
    private static VOIP voip_in;

    static void setScHomeDir(String osName) {
        boolean isHomeDirnameForced;
        String location = System.getProperty(PNAME_SC_HOME_DIR_LOCATION);
        String name = System.getProperty(PNAME_SC_HOME_DIR_NAME);
        boolean bl = isHomeDirnameForced = name != null;
        if (location == null || name == null) {
            boolean chekLegacyDirNames;
            String defaultLocation = System.getProperty("user.home");
            String defaultName = ".vms";
            boolean bl2 = chekLegacyDirNames = name == null || name.equals(overridableDirName);
            if (osName.startsWith("Mac")) {
                if (location == null) {
                    location = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support";
                }
                if (name == null) {
                    name = "vms";
                }
            } else if (osName.startsWith("Windows")) {
                if (location == null) {
                    location = System.getenv("APPDATA");
                }
                if (name == null) {
                    name = "vms";
                }
            }
            if (location == null) {
                location = defaultLocation;
            }
            if (name == null) {
                name = defaultName;
            }
            if (!isHomeDirnameForced && !new File(location, name).isDirectory() && new File(defaultLocation, defaultName).isDirectory()) {
                location = defaultLocation;
                name = defaultName;
            }
            if (chekLegacyDirNames && !OSGi.checkHomeFolderExist(location, name, osName)) {
                for (int i = 0; i < legacyDirNames.length; ++i) {
                    if (OSGi.checkHomeFolderExist(location, legacyDirNames[i], osName)) {
                        name = legacyDirNames[i];
                        break;
                    }
                    if (!OSGi.checkHomeFolderExist(defaultLocation, legacyDirNames[i], osName)) continue;
                    name = legacyDirNames[i];
                    location = defaultLocation;
                    break;
                }
            }
            System.setProperty(PNAME_SC_HOME_DIR_LOCATION, location);
            System.setProperty(PNAME_SC_HOME_DIR_NAME, name);
        }
        new File(location, name + File.separator + "log").mkdirs();
    }

    static boolean checkHomeFolderExist(String parent, String name, String osName) {
        if (osName.startsWith("Mac")) {
            for (int i = 0; i < legacyConfigurationFileNames.length; ++i) {
                if (!new File(new File(parent, name), legacyConfigurationFileNames[i]).exists()) continue;
                return true;
            }
            return false;
        }
        return new File(parent, name).isDirectory();
    }

    public static void init(VOIPLink link) throws Exception {
        Endpoint.publish((String)"http://localhost:5993/voip", (Object)new OSGi());
        il = link;
        System.setProperty("felix.config.properties", "file:lib/infor.felix.client.run.properties");
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            System.setProperty("sun.java2d.d3d", "false");
        }
        OSGi.setScHomeDir(osName);
        File f = new File(System.getProperty(PNAME_SC_HOME_DIR_LOCATION), System.getProperty(PNAME_SC_HOME_DIR_NAME) + File.separator + ".usednsjava");
        if (f.exists()) {
            System.setProperty("sun.net.spi.nameservice.provider.1", "dns,dnsjava");
        }
        Main.main((String[])new String[0]);
    }

    public static ru.infor.sip.wsdl.OSGi getVOIP_out() {
        if (voip_out == null) {
            OSGiService service = new OSGiService();
            voip_out = service.getOSGiPort();
        }
        return voip_out;
    }

    public static VOIP getVOIP_in() {
        if (voip_in == null) {
            VOIPService service = new VOIPService();
            voip_in = service.getVOIPPort();
        }
        return voip_in;
    }

    public static void answer(String id) {
        OSGi.getVOIP_in().answer(id);
    }

    public static void incoming(String id, String address) {
        OSGi.getVOIP_out().wIncoming(id, address);
    }

    public static void outgoing(String id, String address) {
        OSGi.getVOIP_out().wOutgoing(id, address);
    }

    public static void state(String id, String state) {
        OSGi.getVOIP_out().wState(id, state);
    }

    public static void call(String address) throws OperationFailedException_Exception, ParseException_Exception {
        OSGi.getVOIP_in().call(address);
    }

    public static void register(HashMap<String, String> data) {
        ArrayList<String> k = new ArrayList<String>(data.keySet());
        ArrayList<String> v = new ArrayList<String>(data.values());
        OSGi.getVOIP_in().register(k, v);
    }

    public static void hangup(String id) {
        OSGi.getVOIP_in().hangup(id);
    }

    @WebMethod
    public void w_incoming(String id, String address) {
        il.incomingCall(id, address);
    }

    @WebMethod
    public void w_outgoing(String id, String address) {
        il.outgoingCall(id, address);
    }

    @WebMethod
    public void w_state(String id, String state) {
        il.state(id, state);
    }
}

