/*
 * Decompiled with CFR 0.152.
 */
package ru.infor.sip.util1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.ws.Endpoint;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderFactorySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import ru.infor.sip.OSGi;
import ru.infor.sip.util1.Ath;
import ru.infor.sip.util1.VOIP;

public class Launcher
implements BundleActivator {
    private static OperationSetBasicTelephony<?> telephony;
    private static ArrayList<CallPeer> peers;
    private static BundleContext context;

    static {
        peers = new ArrayList();
    }

    public static void register(String[] keys, String[] values) {
        HashMap<String, String> data = new HashMap<String, String>();
        int i = 0;
        while (i < keys.length) {
            data.put(keys[i], values[i]);
            ++i;
        }
        ProtocolProviderFactorySipImpl ppf = new ProtocolProviderFactorySipImpl();
        AccountID a = ppf.loadAccount(data);
        ServiceReference psr = ppf.getProviderForAccount(a);
        ProtocolProviderServiceSipImpl p = (ProtocolProviderServiceSipImpl)context.getService(psr);
        p.addRegistrationStateChangeListener(new RegistrationStateChangeListener(){

            public void registrationStateChanged(RegistrationStateChangeEvent evt) {
                OSGi.state(evt.getProvider().getProtocolDisplayName(), evt.getNewState().getStateName());
            }
        });
        try {
            Ath dsa = new Ath();
            p.register((SecurityAuthority)dsa);
            while (!p.isRegistered()) {
                Thread.sleep(10L);
            }
            telephony = (OperationSetBasicTelephony)p.getOperationSet(OperationSetBasicTelephony.class);
            telephony.addCallListener(new CallListener(){

                public void outgoingCallCreated(CallEvent event) {
                    for (final CallPeer peer : event.getCallConference().getCallPeers()) {
                        peers.add(peer);
                        OSGi.outgoing(peer.getPeerID(), peer.getAddress());
                        peer.addCallPeerListener(new CallPeerListener(){

                            public void peerTransportAddressChanged(CallPeerChangeEvent evt) {
                            }

                            public void peerStateChanged(CallPeerChangeEvent evt) {
                                OSGi.state(peer.getPeerID(), ((CallPeerState)evt.getNewValue()).getStateString());
                            }

                            public void peerImageChanged(CallPeerChangeEvent evt) {
                            }

                            public void peerDisplayNameChanged(CallPeerChangeEvent evt) {
                            }

                            public void peerAddressChanged(CallPeerChangeEvent evt) {
                            }
                        });
                    }
                }

                public void incomingCallReceived(CallEvent event) {
                    final Call peer = event.getSourceCall();
                    CallPeer cp = (CallPeer)peer.getCallPeers().next();
                    peers.add(cp);
                    OSGi.incoming(cp.getPeerID(), cp.getAddress());
                    new Thread(new Runnable(){

                        public void run() {
                            Iterator i = peer.getCallPeers();
                            while (i.hasNext()) {
                                final CallPeer ca = (CallPeer)i.next();
                                ca.getCall().addCallChangeListener(new CallChangeListener(){

                                    public void callStateChanged(CallChangeEvent evt) {
                                        OSGi.state(ca.getPeerID(), ((CallState)evt.getNewValue()).getStateString());
                                    }

                                    public void callPeerRemoved(CallPeerEvent evt) {
                                    }

                                    public void callPeerAdded(CallPeerEvent evt) {
                                    }
                                });
                            }
                        }
                    }).start();
                }

                public void callEnded(CallEvent event) {
                }
            });
        }
        catch (Exception e) {
            OSGi.state("ERROR", e.getMessage());
            e.printStackTrace();
        }
    }

    public void start(BundleContext context) throws Exception {
        Launcher.context = context;
        Endpoint.publish((String)"http://localhost:5994/voip", (Object)new VOIP());
        OSGi.state("System", "READY");
    }

    public static void call(final String address) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    telephony.createCall(address);
                }
                catch (Exception e) {
                    OSGi.state("ERROR", e.getMessage());
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void stop(BundleContext context) throws Exception {
        System.out.println("Stop");
    }

    public static void answer(String id) {
        for (final CallPeer p : peers) {
            if (!p.getPeerID().equals(id)) continue;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        telephony.answerCallPeer(p);
                    }
                    catch (OperationFailedException e) {
                        OSGi.state("ERROR", e.getMessage());
                        e.printStackTrace();
                    }
                }
            }).start();
            break;
        }
    }

    public static void hangup(String id) {
        for (final CallPeer p : peers) {
            if (!p.getPeerID().equals(id)) continue;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        telephony.hangupCallPeer(p);
                    }
                    catch (OperationFailedException e) {
                        OSGi.state("ERROR", e.getMessage());
                        e.printStackTrace();
                    }
                }
            }).start();
            peers.remove(p);
            break;
        }
    }
}

