/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core;

import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.Maps;
import io.advantageous.boon.core.Sets;
import io.advantageous.boon.core.Sys;
import io.advantageous.boon.primitive.Arry;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LazyMap
extends AbstractMap<String, Object> {
    static final boolean althashingThreshold = System.getProperty("jdk.map.althashing.threshold") != null;
    private final boolean delayMap;
    private Map<String, Object> map;
    private int size;
    private String[] keys;
    private Object[] values;

    public LazyMap() {
        this.keys = new String[5];
        this.values = new Object[5];
        this.delayMap = false;
    }

    public LazyMap(int initialSize) {
        this.keys = new String[initialSize];
        this.values = new Object[initialSize];
        this.delayMap = false;
    }

    public LazyMap(int initialSize, boolean delayMap) {
        this.keys = new String[initialSize];
        this.values = new Object[initialSize];
        this.delayMap = delayMap;
    }

    public LazyMap(List<String> keys, List values, boolean delayMap) {
        this.keys = Arry.array(String.class, keys);
        this.values = Arry.array(Object.class, values);
        this.size = this.keys.length;
        this.delayMap = delayMap;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.map == null) {
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            if (this.size == this.keys.length) {
                this.keys = Arry.grow(this.keys);
                this.values = Arry.grow(this.values);
            }
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.map != null) {
            this.map.entrySet();
        }
        if (this.delayMap) {
            return new FakeMapEntrySet(this.size, this.keys, this.values);
        }
        this.buildIfNeeded();
        return this.map.entrySet();
    }

    @Override
    public int size() {
        if (this.map == null) {
            return this.size;
        }
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return this.size == 0;
        }
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.map == null) {
            throw new RuntimeException("wrong type of map");
        }
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.buildIfNeeded();
        return this.map.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        this.buildIfNeeded();
        return this.map.get(key);
    }

    private void buildIfNeeded() {
        if (this.map == null) {
            this.map = Sys.is1_7OrLater() && althashingThreshold ? new LinkedHashMap<String, Object>(this.size, 0.01f) : new TreeMap<String, Object>();
            for (int index = 0; index < this.size; ++index) {
                this.map.put(this.keys[index], this.values[index]);
            }
            this.keys = null;
            this.values = null;
        }
    }

    @Override
    public Object remove(Object key) {
        this.buildIfNeeded();
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.buildIfNeeded();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.size = 0;
        } else {
            this.map.clear();
        }
    }

    @Override
    public Set<String> keySet() {
        if (this.map == null) {
            return Sets.set(this.size, this.keys);
        }
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        if (this.map == null) {
            return Arrays.asList(this.values);
        }
        return this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        this.buildIfNeeded();
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        this.buildIfNeeded();
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        this.buildIfNeeded();
        return this.map.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        if (this.map == null) {
            return null;
        }
        if (this.map instanceof LinkedHashMap) {
            return ((LinkedHashMap)this.map).clone();
        }
        return Maps.copy(this);
    }

    public LazyMap clearAndCopy() {
        LazyMap map = new LazyMap(this.size);
        for (int index = 0; index < this.size; ++index) {
            map.put(this.keys[index], this.values[index]);
        }
        this.size = 0;
        return map;
    }

    public static class FakeMapEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        Map.Entry<String, Object>[] array;

        public FakeMapEntrySet(int size, String[] keys, Object[] values) {
            this.array = new Map.Entry[size];
            for (int index = 0; index < size; ++index) {
                this.array[index] = Maps.entry(keys[index], values[index]);
            }
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return Lists.list(this.array).iterator();
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }
}

