/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core;

import io.advantageous.boon.core.Entry;
import io.advantageous.boon.core.Exceptions;

public class Pair<K, V>
implements Entry<K, V> {
    private K k;
    private V v;

    public static <K, V> Entry<K, V> entry(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    public static <K, V> Pair<K, V> pair(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    public static <K, V> Entry<K, V> entry(Entry<K, V> entry) {
        return new Pair<K, V>(entry);
    }

    public Pair() {
    }

    public Pair(Pair<K, V> impl) {
        Exceptions.requireNonNull(impl);
        Exceptions.requireNonNull(impl.k);
        this.k = impl.k;
        this.v = impl.v;
    }

    public Pair(Entry<K, V> entry) {
        Exceptions.requireNonNull(entry);
        Exceptions.requireNonNull(entry.key());
        this.k = entry.key();
        this.v = entry.value();
    }

    public Pair(K k, V v) {
        Exceptions.requireNonNull(k);
        this.k = k;
        this.v = v;
    }

    @Override
    public K key() {
        return this.k;
    }

    public K getFirst() {
        return this.k;
    }

    public V getSecond() {
        return this.v;
    }

    @Override
    public V value() {
        return this.v;
    }

    @Override
    public K getKey() {
        return this.k;
    }

    @Override
    public V getValue() {
        return this.v;
    }

    @Override
    public V setValue(V value) {
        V old = this.v;
        this.v = value;
        return old;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair entry = (Pair)o;
        return this.equals(entry);
    }

    @Override
    public boolean equals(Entry entry) {
        if (this.k != null ? !this.k.equals(entry.key()) : entry.key() != null) {
            return false;
        }
        return !(this.v == null ? entry.value() != null : !this.v.equals(entry.value()));
    }

    @Override
    public int hashCode() {
        int result = this.k != null ? this.k.hashCode() : 0;
        result = 31 * result + (this.v != null ? this.v.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Entry entry) {
        Exceptions.requireNonNull(entry);
        return this.key().toString().compareTo(entry.key().toString());
    }

    public String toString() {
        return "{\"k\":" + this.k + ", \"v\":" + this.v + '}';
    }

    public void setFirst(K first) {
        this.k = first;
    }

    public void setSecond(V v) {
        this.v = v;
    }
}

